/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2ByteFunction;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractLong2ByteMap
extends AbstractLong2ByteFunction
implements Long2ByteMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractLong2ByteMap() {
    }

    @Override
    public boolean containsValue(byte v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(long k2) {
        Iterator i2 = this.long2ByteEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Long2ByteMap.Entry)i2.next()).getLongKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            @Override
            public boolean contains(long k2) {
                return AbstractLong2ByteMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractLong2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2ByteMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Long2ByteMap.Entry> i;
                    {
                        this.i = Long2ByteMaps.fastIterator(AbstractLong2ByteMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Long2ByteMap.Entry)this.i.next()).getLongKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ByteCollection values() {
        return new AbstractByteCollection(){

            @Override
            public boolean contains(byte k2) {
                return AbstractLong2ByteMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractLong2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2ByteMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Long2ByteMap.Entry> i;
                    {
                        this.i = Long2ByteMaps.fastIterator(AbstractLong2ByteMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Long2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Byte> m2) {
        if (m2 instanceof Long2ByteMap) {
            ObjectIterator<Long2ByteMap.Entry> i2 = Long2ByteMaps.fastIterator((Long2ByteMap)m2);
            while (i2.hasNext()) {
                Long2ByteMap.Entry e2 = (Long2ByteMap.Entry)i2.next();
                this.put(e2.getLongKey(), e2.getByteValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Long, ? extends Byte>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Long, ? extends Byte> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Long2ByteMap.Entry> i2 = Long2ByteMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Long2ByteMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.long2ByteEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Long2ByteMap.Entry> i2 = Long2ByteMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Long2ByteMap.Entry e2 = (Long2ByteMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getLongKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getByteValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Long2ByteMap.Entry> {
        protected final Long2ByteMap map;

        public BasicEntrySet(Long2ByteMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2ByteMap.Entry) {
                Long2ByteMap.Entry e2 = (Long2ByteMap.Entry)o2;
                long k2 = e2.getLongKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k3 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Byte)value).byteValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2ByteMap.Entry) {
                Long2ByteMap.Entry e2 = (Long2ByteMap.Entry)o2;
                return this.map.remove(e2.getLongKey(), e2.getByteValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k2 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            byte v2 = (Byte)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Long2ByteMap.Entry {
        protected long key;
        protected byte value;

        public BasicEntry() {
        }

        public BasicEntry(Long key, Byte value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(long key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public byte getByteValue() {
            return this.value;
        }

        @Override
        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2ByteMap.Entry) {
                Long2ByteMap.Entry e2 = (Long2ByteMap.Entry)o2;
                return this.key == e2.getLongKey() && this.value == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.key == (Long)key && this.value == (Byte)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

