/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2BooleanFunction;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractLong2BooleanMap
extends AbstractLong2BooleanFunction
implements Long2BooleanMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractLong2BooleanMap() {
    }

    @Override
    public boolean containsValue(boolean v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(long k2) {
        Iterator i2 = this.long2BooleanEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Long2BooleanMap.Entry)i2.next()).getLongKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            @Override
            public boolean contains(long k2) {
                return AbstractLong2BooleanMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractLong2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2BooleanMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Long2BooleanMap.Entry> i;
                    {
                        this.i = Long2BooleanMaps.fastIterator(AbstractLong2BooleanMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Long2BooleanMap.Entry)this.i.next()).getLongKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k2) {
                return AbstractLong2BooleanMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractLong2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Long2BooleanMap.Entry> i;
                    {
                        this.i = Long2BooleanMaps.fastIterator(AbstractLong2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Long2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Boolean> m2) {
        if (m2 instanceof Long2BooleanMap) {
            ObjectIterator<Long2BooleanMap.Entry> i2 = Long2BooleanMaps.fastIterator((Long2BooleanMap)m2);
            while (i2.hasNext()) {
                Long2BooleanMap.Entry e2 = (Long2BooleanMap.Entry)i2.next();
                this.put(e2.getLongKey(), e2.getBooleanValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Long, ? extends Boolean>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Long, ? extends Boolean> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Long2BooleanMap.Entry> i2 = Long2BooleanMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Long2BooleanMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.long2BooleanEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Long2BooleanMap.Entry> i2 = Long2BooleanMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Long2BooleanMap.Entry e2 = (Long2BooleanMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getLongKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getBooleanValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Long2BooleanMap.Entry> {
        protected final Long2BooleanMap map;

        public BasicEntrySet(Long2BooleanMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2BooleanMap.Entry) {
                Long2BooleanMap.Entry e2 = (Long2BooleanMap.Entry)o2;
                long k2 = e2.getLongKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k3 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Boolean)value).booleanValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2BooleanMap.Entry) {
                Long2BooleanMap.Entry e2 = (Long2BooleanMap.Entry)o2;
                return this.map.remove(e2.getLongKey(), e2.getBooleanValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k2 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            boolean v2 = (Boolean)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Long2BooleanMap.Entry {
        protected long key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(Long key, Boolean value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(long key, boolean value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2BooleanMap.Entry) {
                Long2BooleanMap.Entry e2 = (Long2BooleanMap.Entry)o2;
                return this.key == e2.getLongKey() && this.value == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.key == (Long)key && this.value == (Boolean)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(this.key) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

