/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntHeaps;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntHeapPriorityQueue
implements IntPriorityQueue,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient int[] heap = IntArrays.EMPTY_ARRAY;
    protected int size;
    protected IntComparator c;

    public IntHeapPriorityQueue(int capacity, IntComparator c2) {
        if (capacity > 0) {
            this.heap = new int[capacity];
        }
        this.c = c2;
    }

    public IntHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public IntHeapPriorityQueue(IntComparator c2) {
        this(0, c2);
    }

    public IntHeapPriorityQueue() {
        this(0, null);
    }

    public IntHeapPriorityQueue(int[] a2, int size, IntComparator c2) {
        this(c2);
        this.heap = a2;
        this.size = size;
        IntHeaps.makeHeap(a2, size, c2);
    }

    public IntHeapPriorityQueue(int[] a2, IntComparator c2) {
        this(a2, a2.length, c2);
    }

    public IntHeapPriorityQueue(int[] a2, int size) {
        this(a2, size, null);
    }

    public IntHeapPriorityQueue(int[] a2) {
        this(a2, a2.length);
    }

    public IntHeapPriorityQueue(IntCollection collection, IntComparator c2) {
        this(collection.toIntArray(), c2);
    }

    public IntHeapPriorityQueue(IntCollection collection) {
        this(collection, (IntComparator)null);
    }

    public IntHeapPriorityQueue(Collection<? extends Integer> collection, IntComparator c2) {
        this(collection.size(), c2);
        Iterator<? extends Integer> iterator = collection.iterator();
        int size = collection.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.heap[i2] = iterator.next();
        }
    }

    public IntHeapPriorityQueue(Collection<? extends Integer> collection) {
        this(collection, null);
    }

    @Override
    public void enqueue(int x2) {
        if (this.size == this.heap.length) {
            this.heap = IntArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x2;
        IntHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public int dequeueInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            IntHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public int firstInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        IntHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = IntArrays.trim(this.heap, this.size);
    }

    @Override
    public IntComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.heap.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeInt(this.heap[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.heap = new int[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.heap[i2] = s2.readInt();
        }
    }
}

