/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2FloatMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntHash;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;

public class Int2FloatOpenCustomHashMap
extends AbstractInt2FloatMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient int[] key;
    protected transient float[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected IntHash.Strategy strategy;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Int2FloatMap.FastEntrySet entries;
    protected transient IntSet keys;
    protected transient FloatCollection values;

    public Int2FloatOpenCustomHashMap(int expected, float f2, IntHash.Strategy strategy) {
        this.strategy = strategy;
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
        this.value = new float[this.n + 1];
    }

    public Int2FloatOpenCustomHashMap(int expected, IntHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public Int2FloatOpenCustomHashMap(IntHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Int2FloatOpenCustomHashMap(Map<? extends Integer, ? extends Float> m2, float f2, IntHash.Strategy strategy) {
        this(m2.size(), f2, strategy);
        this.putAll(m2);
    }

    public Int2FloatOpenCustomHashMap(Map<? extends Integer, ? extends Float> m2, IntHash.Strategy strategy) {
        this(m2, 0.75f, strategy);
    }

    public Int2FloatOpenCustomHashMap(Int2FloatMap m2, float f2, IntHash.Strategy strategy) {
        this(m2.size(), f2, strategy);
        this.putAll(m2);
    }

    public Int2FloatOpenCustomHashMap(Int2FloatMap m2, IntHash.Strategy strategy) {
        this(m2, 0.75f, strategy);
    }

    public Int2FloatOpenCustomHashMap(int[] k2, float[] v2, float f2, IntHash.Strategy strategy) {
        this(k2.length, f2, strategy);
        if (k2.length != v2.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v2.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v2[i2]);
        }
    }

    public Int2FloatOpenCustomHashMap(int[] k2, float[] v2, IntHash.Strategy strategy) {
        this(k2, v2, 0.75f, strategy);
    }

    public IntHash.Strategy strategy() {
        return this.strategy;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private float removeEntry(int pos) {
        float oldValue = this.value[pos];
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private float removeNullEntry() {
        this.containsNullKey = false;
        float oldValue = this.value[this.n];
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Float> m2) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m2.size());
        } else {
            this.tryCapacity(this.size() + m2.size());
        }
        super.putAll(m2);
    }

    private int find(int k2) {
        if (this.strategy.equals(k2, 0)) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return -(pos + 1);
        }
        if (this.strategy.equals(k2, curr)) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return -(pos + 1);
        } while (!this.strategy.equals(k2, curr));
        return pos;
    }

    private void insert(int pos, int k2, float v2) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k2;
        this.value[pos] = v2;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public float put(int k2, float v2) {
        int pos = this.find(k2);
        if (pos < 0) {
            this.insert(-pos - 1, k2, v2);
            return this.defRetValue;
        }
        float oldValue = this.value[pos];
        this.value[pos] = v2;
        return oldValue;
    }

    private float addToValue(int pos, float incr) {
        float oldValue = this.value[pos];
        this.value[pos] = oldValue + incr;
        return oldValue;
    }

    public float addTo(int k2, float incr) {
        int pos;
        if (this.strategy.equals(k2, 0)) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos = this.n;
            this.containsNullKey = true;
        } else {
            int[] key = this.key;
            pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
            int curr = key[pos];
            if (curr != 0) {
                if (this.strategy.equals(curr, k2)) {
                    return this.addToValue(pos, incr);
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0) {
                    if (!this.strategy.equals(curr, k2)) continue;
                    return this.addToValue(pos, incr);
                }
            }
        }
        this.key[pos] = k2;
        this.value[pos] = this.defRetValue + incr;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        int[] key = this.key;
        while (true) {
            int curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0) {
                    key[last] = 0;
                    return;
                }
                int slot = HashCommon.mix(this.strategy.hashCode(curr)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos];
        }
    }

    @Override
    public float remove(int k2) {
        if (this.strategy.equals(k2, 0)) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        int[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k2, curr)) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k2, curr));
        return this.removeEntry(pos);
    }

    @Override
    public float get(int k2) {
        if (this.strategy.equals(k2, 0)) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        int[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k2, curr)) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k2, curr));
        return this.value[pos];
    }

    @Override
    public boolean containsKey(int k2) {
        if (this.strategy.equals(k2, 0)) {
            return this.containsNullKey;
        }
        int[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return false;
        }
        if (this.strategy.equals(k2, curr)) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return false;
        } while (!this.strategy.equals(k2, curr));
        return true;
    }

    @Override
    public boolean containsValue(float v2) {
        float[] value = this.value;
        int[] key = this.key;
        if (this.containsNullKey && Float.floatToIntBits(value[this.n]) == Float.floatToIntBits(v2)) {
            return true;
        }
        int i2 = this.n;
        while (i2-- != 0) {
            if (key[i2] == 0 || Float.floatToIntBits(value[i2]) != Float.floatToIntBits(v2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getOrDefault(int k2, float defaultValue) {
        if (this.strategy.equals(k2, 0)) {
            return this.containsNullKey ? this.value[this.n] : defaultValue;
        }
        int[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return defaultValue;
        }
        if (this.strategy.equals(k2, curr)) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return defaultValue;
        } while (!this.strategy.equals(k2, curr));
        return this.value[pos];
    }

    @Override
    public float putIfAbsent(int k2, float v2) {
        int pos = this.find(k2);
        if (pos >= 0) {
            return this.value[pos];
        }
        this.insert(-pos - 1, k2, v2);
        return this.defRetValue;
    }

    @Override
    public boolean remove(int k2, float v2) {
        if (this.strategy.equals(k2, 0)) {
            if (this.containsNullKey && Float.floatToIntBits(v2) == Float.floatToIntBits(this.value[this.n])) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        int[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return false;
        }
        if (this.strategy.equals(k2, curr) && Float.floatToIntBits(v2) == Float.floatToIntBits(this.value[pos])) {
            this.removeEntry(pos);
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return false;
        } while (!this.strategy.equals(k2, curr) || Float.floatToIntBits(v2) != Float.floatToIntBits(this.value[pos]));
        this.removeEntry(pos);
        return true;
    }

    @Override
    public boolean replace(int k2, float oldValue, float v2) {
        int pos = this.find(k2);
        if (pos < 0 || Float.floatToIntBits(oldValue) != Float.floatToIntBits(this.value[pos])) {
            return false;
        }
        this.value[pos] = v2;
        return true;
    }

    @Override
    public float replace(int k2, float v2) {
        int pos = this.find(k2);
        if (pos < 0) {
            return this.defRetValue;
        }
        float oldValue = this.value[pos];
        this.value[pos] = v2;
        return oldValue;
    }

    @Override
    public float computeIfAbsent(int k2, IntToDoubleFunction mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos = this.find(k2);
        if (pos >= 0) {
            return this.value[pos];
        }
        float newValue = SafeMath.safeDoubleToFloat(mappingFunction.applyAsDouble(k2));
        this.insert(-pos - 1, k2, newValue);
        return newValue;
    }

    @Override
    public float computeIfAbsentNullable(int k2, IntFunction<? extends Float> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos = this.find(k2);
        if (pos >= 0) {
            return this.value[pos];
        }
        Float newValue = mappingFunction.apply(k2);
        if (newValue == null) {
            return this.defRetValue;
        }
        float v2 = newValue.floatValue();
        this.insert(-pos - 1, k2, v2);
        return v2;
    }

    @Override
    public float computeIfPresent(int k2, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos = this.find(k2);
        if (pos < 0) {
            return this.defRetValue;
        }
        Float newValue = remappingFunction.apply((Integer)k2, Float.valueOf(this.value[pos]));
        if (newValue == null) {
            if (this.strategy.equals(k2, 0)) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value[pos] = newValue.floatValue();
        return this.value[pos];
    }

    @Override
    public float compute(int k2, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos = this.find(k2);
        Float newValue = remappingFunction.apply((Integer)k2, pos >= 0 ? Float.valueOf(this.value[pos]) : null);
        if (newValue == null) {
            if (pos >= 0) {
                if (this.strategy.equals(k2, 0)) {
                    this.removeNullEntry();
                } else {
                    this.removeEntry(pos);
                }
            }
            return this.defRetValue;
        }
        float newVal = newValue.floatValue();
        if (pos < 0) {
            this.insert(-pos - 1, k2, newVal);
            return newVal;
        }
        this.value[pos] = newVal;
        return this.value[pos];
    }

    @Override
    public float merge(int k2, float v2, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos = this.find(k2);
        if (pos < 0) {
            this.insert(-pos - 1, k2, v2);
            return v2;
        }
        Float newValue = remappingFunction.apply(Float.valueOf(this.value[pos]), Float.valueOf(v2));
        if (newValue == null) {
            if (this.strategy.equals(k2, 0)) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value[pos] = newValue.floatValue();
        return this.value[pos];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Int2FloatMap.FastEntrySet int2FloatEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public FloatCollection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                @Override
                public FloatIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Int2FloatOpenCustomHashMap.this.size;
                }

                @Override
                public boolean contains(float v2) {
                    return Int2FloatOpenCustomHashMap.this.containsValue(v2);
                }

                @Override
                public void clear() {
                    Int2FloatOpenCustomHashMap.this.clear();
                }

                @Override
                public void forEach(DoubleConsumer consumer) {
                    if (Int2FloatOpenCustomHashMap.this.containsNullKey) {
                        consumer.accept(Int2FloatOpenCustomHashMap.this.value[Int2FloatOpenCustomHashMap.this.n]);
                    }
                    int pos = Int2FloatOpenCustomHashMap.this.n;
                    while (pos-- != 0) {
                        if (Int2FloatOpenCustomHashMap.this.key[pos] == 0) continue;
                        consumer.accept(Int2FloatOpenCustomHashMap.this.value[pos]);
                    }
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        int l2 = HashCommon.arraySize(this.size, this.f);
        if (l2 >= this.n || this.size > HashCommon.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n2) {
        int l2 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (l2 >= n2 || this.size > HashCommon.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int[] key = this.key;
        float[] value = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        float[] newValue = new float[newN + 1];
        int i2 = this.n;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (key[--i2] == 0) {
            }
            int pos = HashCommon.mix(this.strategy.hashCode(key[i2])) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i2];
            newValue[pos] = value[i2];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Int2FloatOpenCustomHashMap clone() {
        Int2FloatOpenCustomHashMap c2;
        try {
            c2 = (Int2FloatOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.keys = null;
        c2.values = null;
        c2.entries = null;
        c2.containsNullKey = this.containsNullKey;
        c2.key = (int[])this.key.clone();
        c2.value = (float[])this.value.clone();
        c2.strategy = this.strategy;
        return c2;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int j2 = this.realSize();
        int i2 = 0;
        int t2 = 0;
        while (j2-- != 0) {
            while (this.key[i2] == 0) {
                ++i2;
            }
            t2 = this.strategy.hashCode(this.key[i2]);
            h2 += (t2 ^= HashCommon.float2int(this.value[i2]));
            ++i2;
        }
        if (this.containsNullKey) {
            h2 += HashCommon.float2int(this.value[this.n]);
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int[] key = this.key;
        float[] value = this.value;
        MapIterator i2 = new MapIterator();
        s2.defaultWriteObject();
        int j2 = this.size;
        while (j2-- != 0) {
            int e2 = i2.nextEntry();
            s2.writeInt(key[e2]);
            s2.writeFloat(value[e2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n + 1];
        int[] key = this.key;
        this.value = new float[this.n + 1];
        float[] value = this.value;
        int i2 = this.size;
        while (i2-- != 0) {
            int pos;
            int k2 = s2.readInt();
            float v2 = s2.readFloat();
            if (this.strategy.equals(k2, 0)) {
                pos = this.n;
                this.containsNullKey = true;
            } else {
                pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
                while (key[pos] != 0) {
                    pos = pos + 1 & this.mask;
                }
            }
            key[pos] = k2;
            value[pos] = v2;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements FloatIterator {
        @Override
        public float nextFloat() {
            return Int2FloatOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        @Override
        public IntIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public void forEach(IntConsumer consumer) {
            if (Int2FloatOpenCustomHashMap.this.containsNullKey) {
                consumer.accept(Int2FloatOpenCustomHashMap.this.key[Int2FloatOpenCustomHashMap.this.n]);
            }
            int pos = Int2FloatOpenCustomHashMap.this.n;
            while (pos-- != 0) {
                int k2 = Int2FloatOpenCustomHashMap.this.key[pos];
                if (k2 == 0) continue;
                consumer.accept(k2);
            }
        }

        @Override
        public int size() {
            return Int2FloatOpenCustomHashMap.this.size;
        }

        @Override
        public boolean contains(int k2) {
            return Int2FloatOpenCustomHashMap.this.containsKey(k2);
        }

        @Override
        public boolean remove(int k2) {
            int oldSize = Int2FloatOpenCustomHashMap.this.size;
            Int2FloatOpenCustomHashMap.this.remove(k2);
            return Int2FloatOpenCustomHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Int2FloatOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int nextInt() {
            return Int2FloatOpenCustomHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Int2FloatMap.Entry>
    implements Int2FloatMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Int2FloatMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Int2FloatMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            if (e2.getKey() == null || !(e2.getKey() instanceof Integer)) {
                return false;
            }
            if (e2.getValue() == null || !(e2.getValue() instanceof Float)) {
                return false;
            }
            int k2 = (Integer)e2.getKey();
            float v2 = ((Float)e2.getValue()).floatValue();
            if (Int2FloatOpenCustomHashMap.this.strategy.equals(k2, 0)) {
                return Int2FloatOpenCustomHashMap.this.containsNullKey && Float.floatToIntBits(Int2FloatOpenCustomHashMap.this.value[Int2FloatOpenCustomHashMap.this.n]) == Float.floatToIntBits(v2);
            }
            int[] key = Int2FloatOpenCustomHashMap.this.key;
            int pos = HashCommon.mix(Int2FloatOpenCustomHashMap.this.strategy.hashCode(k2)) & Int2FloatOpenCustomHashMap.this.mask;
            int curr = key[pos];
            if (curr == 0) {
                return false;
            }
            if (Int2FloatOpenCustomHashMap.this.strategy.equals(k2, curr)) {
                return Float.floatToIntBits(Int2FloatOpenCustomHashMap.this.value[pos]) == Float.floatToIntBits(v2);
            }
            do {
                if ((curr = key[pos = pos + 1 & Int2FloatOpenCustomHashMap.this.mask]) != 0) continue;
                return false;
            } while (!Int2FloatOpenCustomHashMap.this.strategy.equals(k2, curr));
            return Float.floatToIntBits(Int2FloatOpenCustomHashMap.this.value[pos]) == Float.floatToIntBits(v2);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            if (e2.getKey() == null || !(e2.getKey() instanceof Integer)) {
                return false;
            }
            if (e2.getValue() == null || !(e2.getValue() instanceof Float)) {
                return false;
            }
            int k2 = (Integer)e2.getKey();
            float v2 = ((Float)e2.getValue()).floatValue();
            if (Int2FloatOpenCustomHashMap.this.strategy.equals(k2, 0)) {
                if (Int2FloatOpenCustomHashMap.this.containsNullKey && Float.floatToIntBits(Int2FloatOpenCustomHashMap.this.value[Int2FloatOpenCustomHashMap.this.n]) == Float.floatToIntBits(v2)) {
                    Int2FloatOpenCustomHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            int[] key = Int2FloatOpenCustomHashMap.this.key;
            int pos = HashCommon.mix(Int2FloatOpenCustomHashMap.this.strategy.hashCode(k2)) & Int2FloatOpenCustomHashMap.this.mask;
            int curr = key[pos];
            if (curr == 0) {
                return false;
            }
            if (Int2FloatOpenCustomHashMap.this.strategy.equals(curr, k2)) {
                if (Float.floatToIntBits(Int2FloatOpenCustomHashMap.this.value[pos]) == Float.floatToIntBits(v2)) {
                    Int2FloatOpenCustomHashMap.this.removeEntry(pos);
                    return true;
                }
                return false;
            }
            do {
                if ((curr = key[pos = pos + 1 & Int2FloatOpenCustomHashMap.this.mask]) != 0) continue;
                return false;
            } while (!Int2FloatOpenCustomHashMap.this.strategy.equals(curr, k2) || Float.floatToIntBits(Int2FloatOpenCustomHashMap.this.value[pos]) != Float.floatToIntBits(v2));
            Int2FloatOpenCustomHashMap.this.removeEntry(pos);
            return true;
        }

        @Override
        public int size() {
            return Int2FloatOpenCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            Int2FloatOpenCustomHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super Int2FloatMap.Entry> consumer) {
            if (Int2FloatOpenCustomHashMap.this.containsNullKey) {
                consumer.accept(new AbstractInt2FloatMap.BasicEntry(Int2FloatOpenCustomHashMap.this.key[Int2FloatOpenCustomHashMap.this.n], Int2FloatOpenCustomHashMap.this.value[Int2FloatOpenCustomHashMap.this.n]));
            }
            int pos = Int2FloatOpenCustomHashMap.this.n;
            while (pos-- != 0) {
                if (Int2FloatOpenCustomHashMap.this.key[pos] == 0) continue;
                consumer.accept(new AbstractInt2FloatMap.BasicEntry(Int2FloatOpenCustomHashMap.this.key[pos], Int2FloatOpenCustomHashMap.this.value[pos]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Int2FloatMap.Entry> consumer) {
            AbstractInt2FloatMap.BasicEntry entry = new AbstractInt2FloatMap.BasicEntry();
            if (Int2FloatOpenCustomHashMap.this.containsNullKey) {
                entry.key = Int2FloatOpenCustomHashMap.this.key[Int2FloatOpenCustomHashMap.this.n];
                entry.value = Int2FloatOpenCustomHashMap.this.value[Int2FloatOpenCustomHashMap.this.n];
                consumer.accept(entry);
            }
            int pos = Int2FloatOpenCustomHashMap.this.n;
            while (pos-- != 0) {
                if (Int2FloatOpenCustomHashMap.this.key[pos] == 0) continue;
                entry.key = Int2FloatOpenCustomHashMap.this.key[pos];
                entry.value = Int2FloatOpenCustomHashMap.this.value[pos];
                consumer.accept(entry);
            }
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Int2FloatMap.Entry> {
        private final MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Int2FloatMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        boolean mustReturnNullKey;
        IntArrayList wrapped;

        private MapIterator() {
            this.pos = Int2FloatOpenCustomHashMap.this.n;
            this.last = -1;
            this.c = Int2FloatOpenCustomHashMap.this.size;
            this.mustReturnNullKey = Int2FloatOpenCustomHashMap.this.containsNullKey;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Int2FloatOpenCustomHashMap.this.n;
                return this.last;
            }
            int[] key = Int2FloatOpenCustomHashMap.this.key;
            do {
                if (--this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                int k2 = this.wrapped.getInt(-this.pos - 1);
                int p2 = HashCommon.mix(Int2FloatOpenCustomHashMap.this.strategy.hashCode(k2)) & Int2FloatOpenCustomHashMap.this.mask;
                while (!Int2FloatOpenCustomHashMap.this.strategy.equals(k2, key[p2])) {
                    p2 = p2 + 1 & Int2FloatOpenCustomHashMap.this.mask;
                }
                return p2;
            } while (key[this.pos] == 0);
            this.last = this.pos;
            return this.last;
        }

        private void shiftKeys(int pos) {
            int[] key = Int2FloatOpenCustomHashMap.this.key;
            while (true) {
                int curr;
                int last = pos;
                pos = last + 1 & Int2FloatOpenCustomHashMap.this.mask;
                while (true) {
                    if ((curr = key[pos]) == 0) {
                        key[last] = 0;
                        return;
                    }
                    int slot = HashCommon.mix(Int2FloatOpenCustomHashMap.this.strategy.hashCode(curr)) & Int2FloatOpenCustomHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Int2FloatOpenCustomHashMap.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new IntArrayList(2);
                    }
                    this.wrapped.add(key[pos]);
                }
                key[last] = curr;
                Int2FloatOpenCustomHashMap.this.value[last] = Int2FloatOpenCustomHashMap.this.value[pos];
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == Int2FloatOpenCustomHashMap.this.n) {
                Int2FloatOpenCustomHashMap.this.containsNullKey = false;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                Int2FloatOpenCustomHashMap.this.remove(this.wrapped.getInt(-this.pos - 1));
                this.last = -1;
                return;
            }
            --Int2FloatOpenCustomHashMap.this.size;
            this.last = -1;
        }

        public int skip(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i2 - 1;
        }
    }

    final class MapEntry
    implements Int2FloatMap.Entry,
    Map.Entry<Integer, Float> {
        int index;

        MapEntry(int index) {
            this.index = index;
        }

        MapEntry() {
        }

        @Override
        public int getIntKey() {
            return Int2FloatOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public float getFloatValue() {
            return Int2FloatOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public float setValue(float v2) {
            float oldValue = Int2FloatOpenCustomHashMap.this.value[this.index];
            Int2FloatOpenCustomHashMap.this.value[this.index] = v2;
            return oldValue;
        }

        @Override
        @Deprecated
        public Integer getKey() {
            return Int2FloatOpenCustomHashMap.this.key[this.index];
        }

        @Override
        @Deprecated
        public Float getValue() {
            return Float.valueOf(Int2FloatOpenCustomHashMap.this.value[this.index]);
        }

        @Override
        @Deprecated
        public Float setValue(Float v2) {
            return Float.valueOf(this.setValue(v2.floatValue()));
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return Int2FloatOpenCustomHashMap.this.strategy.equals(Int2FloatOpenCustomHashMap.this.key[this.index], (Integer)e2.getKey()) && Float.floatToIntBits(Int2FloatOpenCustomHashMap.this.value[this.index]) == Float.floatToIntBits(((Float)e2.getValue()).floatValue());
        }

        @Override
        public int hashCode() {
            return Int2FloatOpenCustomHashMap.this.strategy.hashCode(Int2FloatOpenCustomHashMap.this.key[this.index]) ^ HashCommon.float2int(Int2FloatOpenCustomHashMap.this.value[this.index]);
        }

        public String toString() {
            return Int2FloatOpenCustomHashMap.this.key[this.index] + "=>" + Int2FloatOpenCustomHashMap.this.value[this.index];
        }
    }
}

