/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractInt2ReferenceFunction;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractInt2ReferenceMap<V>
extends AbstractInt2ReferenceFunction<V>
implements Int2ReferenceMap<V>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractInt2ReferenceMap() {
    }

    @Override
    public boolean containsValue(Object v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(int k2) {
        Iterator i2 = this.int2ReferenceEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Int2ReferenceMap.Entry)i2.next()).getIntKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean contains(int k2) {
                return AbstractInt2ReferenceMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractInt2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2ReferenceMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Int2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Int2ReferenceMaps.fastIterator(AbstractInt2ReferenceMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2ReferenceMap.Entry)this.i.next()).getIntKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ReferenceCollection<V> values() {
        return new AbstractReferenceCollection<V>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractInt2ReferenceMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractInt2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2ReferenceMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    private final ObjectIterator<Int2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Int2ReferenceMaps.fastIterator(AbstractInt2ReferenceMap.this);
                    }

                    @Override
                    public V next() {
                        return ((Int2ReferenceMap.Entry)this.i.next()).getValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> m2) {
        if (m2 instanceof Int2ReferenceMap) {
            ObjectIterator i2 = Int2ReferenceMaps.fastIterator((Int2ReferenceMap)m2);
            while (i2.hasNext()) {
                Int2ReferenceMap.Entry e2 = (Int2ReferenceMap.Entry)i2.next();
                this.put(e2.getIntKey(), e2.getValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<Integer, V>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<Integer, V> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Int2ReferenceMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Int2ReferenceMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.int2ReferenceEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Int2ReferenceMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Int2ReferenceMap.Entry e2 = (Int2ReferenceMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getIntKey()));
            s2.append("=>");
            if (this == e2.getValue()) {
                s2.append("(this map)");
                continue;
            }
            s2.append(String.valueOf(e2.getValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<V>
    extends AbstractObjectSet<Int2ReferenceMap.Entry<V>> {
        protected final Int2ReferenceMap<V> map;

        public BasicEntrySet(Int2ReferenceMap<V> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2ReferenceMap.Entry) {
                Int2ReferenceMap.Entry e2 = (Int2ReferenceMap.Entry)o2;
                int k2 = e2.getIntKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k3 = (Integer)key;
            Object value = e3.getValue();
            return this.map.containsKey(k3) && this.map.get(k3) == value;
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2ReferenceMap.Entry) {
                Int2ReferenceMap.Entry e2 = (Int2ReferenceMap.Entry)o2;
                return this.map.remove(e2.getIntKey(), e2.getValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k2 = (Integer)key;
            Object v2 = e3.getValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<V>
    implements Int2ReferenceMap.Entry<V> {
        protected int key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(Integer key, V value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2ReferenceMap.Entry) {
                Int2ReferenceMap.Entry e2 = (Int2ReferenceMap.Entry)o2;
                return this.key == e2.getIntKey() && this.value == e2.getValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            Object value = e3.getValue();
            return this.key == (Integer)key && this.value == value;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : System.identityHashCode(this.value));
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

