/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2DoubleFunction;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractInt2DoubleMap
extends AbstractInt2DoubleFunction
implements Int2DoubleMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractInt2DoubleMap() {
    }

    @Override
    public boolean containsValue(double v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(int k2) {
        Iterator i2 = this.int2DoubleEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Int2DoubleMap.Entry)i2.next()).getIntKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean contains(int k2) {
                return AbstractInt2DoubleMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractInt2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2DoubleMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Int2DoubleMap.Entry> i;
                    {
                        this.i = Int2DoubleMaps.fastIterator(AbstractInt2DoubleMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2DoubleMap.Entry)this.i.next()).getIntKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k2) {
                return AbstractInt2DoubleMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractInt2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Int2DoubleMap.Entry> i;
                    {
                        this.i = Int2DoubleMaps.fastIterator(AbstractInt2DoubleMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Int2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Double> m2) {
        if (m2 instanceof Int2DoubleMap) {
            ObjectIterator<Int2DoubleMap.Entry> i2 = Int2DoubleMaps.fastIterator((Int2DoubleMap)m2);
            while (i2.hasNext()) {
                Int2DoubleMap.Entry e2 = (Int2DoubleMap.Entry)i2.next();
                this.put(e2.getIntKey(), e2.getDoubleValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Integer, ? extends Double>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Integer, ? extends Double> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Int2DoubleMap.Entry> i2 = Int2DoubleMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Int2DoubleMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.int2DoubleEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Int2DoubleMap.Entry> i2 = Int2DoubleMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Int2DoubleMap.Entry e2 = (Int2DoubleMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getIntKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getDoubleValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Int2DoubleMap.Entry> {
        protected final Int2DoubleMap map;

        public BasicEntrySet(Int2DoubleMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2DoubleMap.Entry) {
                Int2DoubleMap.Entry e2 = (Int2DoubleMap.Entry)o2;
                int k2 = e2.getIntKey();
                return this.map.containsKey(k2) && Double.doubleToLongBits(this.map.get(k2)) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k3 = (Integer)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.map.containsKey(k3) && Double.doubleToLongBits(this.map.get(k3)) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2DoubleMap.Entry) {
                Int2DoubleMap.Entry e2 = (Int2DoubleMap.Entry)o2;
                return this.map.remove(e2.getIntKey(), e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k2 = (Integer)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            double v2 = (Double)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Int2DoubleMap.Entry {
        protected int key;
        protected double value;

        public BasicEntry() {
        }

        public BasicEntry(Integer key, Double value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(int key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2DoubleMap.Entry) {
                Int2DoubleMap.Entry e2 = (Int2DoubleMap.Entry)o2;
                return this.key == e2.getIntKey() && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.key == (Integer)key && Double.doubleToLongBits(this.value) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public int hashCode() {
            return this.key ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

