/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2ByteFunction;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractInt2ByteMap
extends AbstractInt2ByteFunction
implements Int2ByteMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractInt2ByteMap() {
    }

    @Override
    public boolean containsValue(byte v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(int k2) {
        Iterator i2 = this.int2ByteEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Int2ByteMap.Entry)i2.next()).getIntKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean contains(int k2) {
                return AbstractInt2ByteMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractInt2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2ByteMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Int2ByteMap.Entry> i;
                    {
                        this.i = Int2ByteMaps.fastIterator(AbstractInt2ByteMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2ByteMap.Entry)this.i.next()).getIntKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ByteCollection values() {
        return new AbstractByteCollection(){

            @Override
            public boolean contains(byte k2) {
                return AbstractInt2ByteMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractInt2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2ByteMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Int2ByteMap.Entry> i;
                    {
                        this.i = Int2ByteMaps.fastIterator(AbstractInt2ByteMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Int2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Byte> m2) {
        if (m2 instanceof Int2ByteMap) {
            ObjectIterator<Int2ByteMap.Entry> i2 = Int2ByteMaps.fastIterator((Int2ByteMap)m2);
            while (i2.hasNext()) {
                Int2ByteMap.Entry e2 = (Int2ByteMap.Entry)i2.next();
                this.put(e2.getIntKey(), e2.getByteValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Integer, ? extends Byte>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Integer, ? extends Byte> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Int2ByteMap.Entry> i2 = Int2ByteMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Int2ByteMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.int2ByteEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Int2ByteMap.Entry> i2 = Int2ByteMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Int2ByteMap.Entry e2 = (Int2ByteMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getIntKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getByteValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Int2ByteMap.Entry> {
        protected final Int2ByteMap map;

        public BasicEntrySet(Int2ByteMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2ByteMap.Entry) {
                Int2ByteMap.Entry e2 = (Int2ByteMap.Entry)o2;
                int k2 = e2.getIntKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k3 = (Integer)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Byte)value).byteValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2ByteMap.Entry) {
                Int2ByteMap.Entry e2 = (Int2ByteMap.Entry)o2;
                return this.map.remove(e2.getIntKey(), e2.getByteValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k2 = (Integer)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            byte v2 = (Byte)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Int2ByteMap.Entry {
        protected int key;
        protected byte value;

        public BasicEntry() {
        }

        public BasicEntry(Integer key, Byte value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(int key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public byte getByteValue() {
            return this.value;
        }

        @Override
        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2ByteMap.Entry) {
                Int2ByteMap.Entry e2 = (Int2ByteMap.Entry)o2;
                return this.key == e2.getIntKey() && this.value == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.key == (Integer)key && this.value == (Byte)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

