/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2BooleanFunction;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractInt2BooleanMap
extends AbstractInt2BooleanFunction
implements Int2BooleanMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractInt2BooleanMap() {
    }

    @Override
    public boolean containsValue(boolean v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(int k2) {
        Iterator i2 = this.int2BooleanEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Int2BooleanMap.Entry)i2.next()).getIntKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean contains(int k2) {
                return AbstractInt2BooleanMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractInt2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2BooleanMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Int2BooleanMap.Entry> i;
                    {
                        this.i = Int2BooleanMaps.fastIterator(AbstractInt2BooleanMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2BooleanMap.Entry)this.i.next()).getIntKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k2) {
                return AbstractInt2BooleanMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractInt2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Int2BooleanMap.Entry> i;
                    {
                        this.i = Int2BooleanMaps.fastIterator(AbstractInt2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Int2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Boolean> m2) {
        if (m2 instanceof Int2BooleanMap) {
            ObjectIterator<Int2BooleanMap.Entry> i2 = Int2BooleanMaps.fastIterator((Int2BooleanMap)m2);
            while (i2.hasNext()) {
                Int2BooleanMap.Entry e2 = (Int2BooleanMap.Entry)i2.next();
                this.put(e2.getIntKey(), e2.getBooleanValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Integer, ? extends Boolean>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Integer, ? extends Boolean> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Int2BooleanMap.Entry> i2 = Int2BooleanMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Int2BooleanMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.int2BooleanEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Int2BooleanMap.Entry> i2 = Int2BooleanMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Int2BooleanMap.Entry e2 = (Int2BooleanMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getIntKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getBooleanValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Int2BooleanMap.Entry> {
        protected final Int2BooleanMap map;

        public BasicEntrySet(Int2BooleanMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2BooleanMap.Entry) {
                Int2BooleanMap.Entry e2 = (Int2BooleanMap.Entry)o2;
                int k2 = e2.getIntKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k3 = (Integer)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Boolean)value).booleanValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2BooleanMap.Entry) {
                Int2BooleanMap.Entry e2 = (Int2BooleanMap.Entry)o2;
                return this.map.remove(e2.getIntKey(), e2.getBooleanValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k2 = (Integer)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            boolean v2 = (Boolean)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Int2BooleanMap.Entry {
        protected int key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(Integer key, Boolean value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(int key, boolean value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Int2BooleanMap.Entry) {
                Int2BooleanMap.Entry e2 = (Int2BooleanMap.Entry)o2;
                return this.key == e2.getIntKey() && this.value == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.key == (Integer)key && this.value == (Boolean)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

