/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollections;
import it.unimi.dsi.fastutil.floats.FloatIterators;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

public final class FloatSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private FloatSets() {
    }

    public static FloatSet singleton(float element) {
        return new Singleton(element);
    }

    public static FloatSet singleton(Float element) {
        return new Singleton(element.floatValue());
    }

    public static FloatSet synchronize(FloatSet s2) {
        return new SynchronizedSet(s2);
    }

    public static FloatSet synchronize(FloatSet s2, Object sync) {
        return new SynchronizedSet(s2, sync);
    }

    public static FloatSet unmodifiable(FloatSet s2) {
        return new UnmodifiableSet(s2);
    }

    public static class UnmodifiableSet
    extends FloatCollections.UnmodifiableCollection
    implements FloatSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(FloatSet s2) {
            super(s2);
        }

        @Override
        public boolean remove(float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.collection.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        @Deprecated
        public boolean rem(float k2) {
            return super.rem(k2);
        }
    }

    public static class SynchronizedSet
    extends FloatCollections.SynchronizedCollection
    implements FloatSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected SynchronizedSet(FloatSet s2, Object sync) {
            super(s2, sync);
        }

        protected SynchronizedSet(FloatSet s2) {
            super(s2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(float k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.rem(k2);
            }
        }

        @Override
        @Deprecated
        public boolean rem(float k2) {
            return super.rem(k2);
        }
    }

    public static class Singleton
    extends AbstractFloatSet
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final float element;

        protected Singleton(float element) {
            this.element = element;
        }

        @Override
        public boolean contains(float k2) {
            return Float.floatToIntBits(k2) == Float.floatToIntBits(this.element);
        }

        @Override
        public boolean remove(float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FloatListIterator iterator() {
            return FloatIterators.singleton(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean addAll(Collection<? extends Float> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptySet
    extends FloatCollections.EmptyCollection
    implements FloatSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public boolean remove(float ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof Set && ((Set)o2).isEmpty();
        }

        @Override
        @Deprecated
        public boolean rem(float k2) {
            return super.rem(k2);
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

