/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatIterators;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FloatOpenHashBigSet
extends AbstractFloatSet
implements Serializable,
Cloneable,
Hash,
Size64 {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[][] key;
    protected transient long mask;
    protected transient int segmentMask;
    protected transient int baseMask;
    protected transient boolean containsNull;
    protected transient long n;
    protected transient long maxFill;
    protected final transient long minN;
    protected final float f;
    protected long size;

    private void initMasks() {
        this.mask = this.n - 1L;
        this.segmentMask = this.key[0].length - 1;
        this.baseMask = this.key.length - 1;
    }

    public FloatOpenHashBigSet(long expected, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (this.n < 0L) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.bigArraySize(expected, f2);
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = FloatBigArrays.newBigArray(this.n);
        this.initMasks();
    }

    public FloatOpenHashBigSet(long expected) {
        this(expected, 0.75f);
    }

    public FloatOpenHashBigSet() {
        this(16L, 0.75f);
    }

    public FloatOpenHashBigSet(Collection<? extends Float> c2, float f2) {
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public FloatOpenHashBigSet(Collection<? extends Float> c2) {
        this(c2, 0.75f);
    }

    public FloatOpenHashBigSet(FloatCollection c2, float f2) {
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public FloatOpenHashBigSet(FloatCollection c2) {
        this(c2, 0.75f);
    }

    public FloatOpenHashBigSet(FloatIterator i2, float f2) {
        this(16L, f2);
        while (i2.hasNext()) {
            this.add(i2.nextFloat());
        }
    }

    public FloatOpenHashBigSet(FloatIterator i2) {
        this(i2, 0.75f);
    }

    public FloatOpenHashBigSet(Iterator<?> i2, float f2) {
        this(FloatIterators.asFloatIterator(i2), f2);
    }

    public FloatOpenHashBigSet(Iterator<?> i2) {
        this(FloatIterators.asFloatIterator(i2));
    }

    public FloatOpenHashBigSet(float[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0L : (long)length, f2);
        FloatArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2[offset + i2]);
        }
    }

    public FloatOpenHashBigSet(float[] a2, int offset, int length) {
        this(a2, offset, length, 0.75f);
    }

    public FloatOpenHashBigSet(float[] a2, float f2) {
        this(a2, 0, a2.length, f2);
    }

    public FloatOpenHashBigSet(float[] a2) {
        this(a2, 0.75f);
    }

    private long realSize() {
        return this.containsNull ? this.size - 1L : this.size;
    }

    private void ensureCapacity(long capacity) {
        long needed = HashCommon.bigArraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    @Override
    public boolean addAll(Collection<? extends Float> c2) {
        long size;
        long l2 = size = c2 instanceof Size64 ? ((Size64)((Object)c2)).size64() : (long)c2.size();
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(size);
        } else {
            this.ensureCapacity(this.size64() + size);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean addAll(FloatCollection c2) {
        long size;
        long l2 = size = c2 instanceof Size64 ? ((Size64)((Object)c2)).size64() : (long)c2.size();
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(size);
        } else {
            this.ensureCapacity(this.size64() + size);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean add(float k2) {
        if (Float.floatToIntBits(k2) == 0) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            int displ;
            float[][] key = this.key;
            long h2 = HashCommon.mix((long)HashCommon.float2int(k2));
            int base = (int)((h2 & this.mask) >>> 27);
            float curr = key[base][displ = (int)(h2 & (long)this.segmentMask)];
            if (Float.floatToIntBits(curr) != 0) {
                if (Float.floatToIntBits(curr) == Float.floatToIntBits(k2)) {
                    return false;
                }
                while (Float.floatToIntBits(curr = key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0) {
                    if (Float.floatToIntBits(curr) != Float.floatToIntBits(k2)) continue;
                    return false;
                }
            }
            key[base][displ] = k2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(2L * this.n);
        }
        return true;
    }

    protected final void shiftKeys(long pos) {
        float[][] key = this.key;
        while (true) {
            long last = pos;
            pos = last + 1L & this.mask;
            while (true) {
                if (Float.floatToIntBits(FloatBigArrays.get(key, pos)) == 0) {
                    FloatBigArrays.set(key, last, 0.0f);
                    return;
                }
                long slot = HashCommon.mix((long)HashCommon.float2int(FloatBigArrays.get(key, pos))) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1L & this.mask;
            }
            FloatBigArrays.set(key, last, FloatBigArrays.get(key, pos));
        }
    }

    private boolean removeEntry(int base, int displ) {
        --this.size;
        this.shiftKeys((long)base * 0x8000000L + (long)displ);
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 16L) {
            this.rehash(this.n / 2L);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 16L) {
            this.rehash(this.n / 2L);
        }
        return true;
    }

    @Override
    public boolean remove(float k2) {
        int displ;
        if (Float.floatToIntBits(k2) == 0) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        float[][] key = this.key;
        long h2 = HashCommon.mix((long)HashCommon.float2int(k2));
        int base = (int)((h2 & this.mask) >>> 27);
        float curr = key[base][displ = (int)(h2 & (long)this.segmentMask)];
        if (Float.floatToIntBits(curr) == 0) {
            return false;
        }
        if (Float.floatToIntBits(curr) == Float.floatToIntBits(k2)) {
            return this.removeEntry(base, displ);
        }
        do {
            if (Float.floatToIntBits(curr = key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0) continue;
            return false;
        } while (Float.floatToIntBits(curr) != Float.floatToIntBits(k2));
        return this.removeEntry(base, displ);
    }

    @Override
    public boolean contains(float k2) {
        int displ;
        if (Float.floatToIntBits(k2) == 0) {
            return this.containsNull;
        }
        float[][] key = this.key;
        long h2 = HashCommon.mix((long)HashCommon.float2int(k2));
        int base = (int)((h2 & this.mask) >>> 27);
        float curr = key[base][displ = (int)(h2 & (long)this.segmentMask)];
        if (Float.floatToIntBits(curr) == 0) {
            return false;
        }
        if (Float.floatToIntBits(curr) == Float.floatToIntBits(k2)) {
            return true;
        }
        do {
            if (Float.floatToIntBits(curr = key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0) continue;
            return false;
        } while (Float.floatToIntBits(curr) != Float.floatToIntBits(k2));
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0L) {
            return;
        }
        this.size = 0L;
        this.containsNull = false;
        FloatBigArrays.fill(this.key, 0.0f);
    }

    @Override
    public FloatIterator iterator() {
        return new SetIterator();
    }

    public boolean trim() {
        long l2 = HashCommon.bigArraySize(this.size, this.f);
        if (l2 >= this.n || this.size > HashCommon.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(long n2) {
        long l2 = HashCommon.bigArraySize(n2, this.f);
        if (this.n <= l2) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(long newN) {
        float[][] key = this.key;
        float[][] newKey = FloatBigArrays.newBigArray(newN);
        long mask = newN - 1L;
        int newSegmentMask = newKey[0].length - 1;
        int newBaseMask = newKey.length - 1;
        int base = 0;
        int displ = 0;
        long i2 = this.realSize();
        while (i2-- != 0L) {
            int d2;
            while (Float.floatToIntBits(key[base][displ]) == 0) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            float k2 = key[base][displ];
            long h2 = HashCommon.mix((long)HashCommon.float2int(k2));
            int b2 = (int)((h2 & mask) >>> 27);
            if (Float.floatToIntBits(newKey[b2][d2 = (int)(h2 & (long)newSegmentMask)]) != 0) {
                while (Float.floatToIntBits(newKey[b2 = b2 + ((d2 = d2 + 1 & newSegmentMask) == 0 ? 1 : 0) & newBaseMask][d2]) != 0) {
                }
            }
            newKey[b2][d2] = k2;
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        this.n = newN;
        this.key = newKey;
        this.initMasks();
        this.maxFill = HashCommon.maxFill(this.n, this.f);
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public FloatOpenHashBigSet clone() {
        FloatOpenHashBigSet c2;
        try {
            c2 = (FloatOpenHashBigSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.key = FloatBigArrays.copy(this.key);
        c2.containsNull = this.containsNull;
        return c2;
    }

    @Override
    public int hashCode() {
        float[][] key = this.key;
        int h2 = 0;
        int base = 0;
        int displ = 0;
        long j2 = this.realSize();
        while (j2-- != 0L) {
            while (Float.floatToIntBits(key[base][displ]) == 0) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            h2 += HashCommon.float2int(key[base][displ]);
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        FloatIterator i2 = this.iterator();
        s2.defaultWriteObject();
        long j2 = this.size;
        while (j2-- != 0L) {
            s2.writeFloat(i2.nextFloat());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.bigArraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = FloatBigArrays.newBigArray(this.n);
        float[][] key = this.key;
        this.initMasks();
        long i2 = this.size;
        while (i2-- != 0L) {
            int displ;
            float k2 = s2.readFloat();
            if (Float.floatToIntBits(k2) == 0) {
                this.containsNull = true;
                continue;
            }
            long h2 = HashCommon.mix((long)HashCommon.float2int(k2));
            int base = (int)((h2 & this.mask) >>> 27);
            if (Float.floatToIntBits(key[base][displ = (int)(h2 & (long)this.segmentMask)]) != 0) {
                while (Float.floatToIntBits(key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0) {
                }
            }
            key[base][displ] = k2;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    implements FloatIterator {
        int base;
        int displ;
        long last;
        long c;
        boolean mustReturnNull;
        FloatArrayList wrapped;

        private SetIterator() {
            this.base = FloatOpenHashBigSet.this.key.length;
            this.last = -1L;
            this.c = FloatOpenHashBigSet.this.size;
            this.mustReturnNull = FloatOpenHashBigSet.this.containsNull;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0L;
        }

        @Override
        public float nextFloat() {
            float k2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = FloatOpenHashBigSet.this.n;
                return 0.0f;
            }
            float[][] key = FloatOpenHashBigSet.this.key;
            do {
                if (this.displ == 0 && this.base <= 0) {
                    this.last = Long.MIN_VALUE;
                    return this.wrapped.getFloat(-(--this.base) - 1);
                }
                if (this.displ-- != 0) continue;
                this.displ = key[--this.base].length - 1;
            } while (Float.floatToIntBits(k2 = key[this.base][this.displ]) == 0);
            this.last = (long)this.base * 0x8000000L + (long)this.displ;
            return k2;
        }

        private final void shiftKeys(long pos) {
            float[][] key = FloatOpenHashBigSet.this.key;
            while (true) {
                float curr;
                long last = pos;
                pos = last + 1L & FloatOpenHashBigSet.this.mask;
                while (true) {
                    if (Float.floatToIntBits(curr = FloatBigArrays.get(key, pos)) == 0) {
                        FloatBigArrays.set(key, last, 0.0f);
                        return;
                    }
                    long slot = HashCommon.mix((long)HashCommon.float2int(curr)) & FloatOpenHashBigSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1L & FloatOpenHashBigSet.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new FloatArrayList();
                    }
                    this.wrapped.add(FloatBigArrays.get(key, pos));
                }
                FloatBigArrays.set(key, last, curr);
            }
        }

        @Override
        public void remove() {
            if (this.last == -1L) {
                throw new IllegalStateException();
            }
            if (this.last == FloatOpenHashBigSet.this.n) {
                FloatOpenHashBigSet.this.containsNull = false;
            } else if (this.base >= 0) {
                this.shiftKeys(this.last);
            } else {
                FloatOpenHashBigSet.this.remove(this.wrapped.getFloat(-this.base - 1));
                this.last = -1L;
                return;
            }
            --FloatOpenHashBigSet.this.size;
            this.last = -1L;
        }
    }
}

