/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatHeaps;
import it.unimi.dsi.fastutil.floats.FloatPriorityQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FloatHeapPriorityQueue
implements FloatPriorityQueue,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient float[] heap = FloatArrays.EMPTY_ARRAY;
    protected int size;
    protected FloatComparator c;

    public FloatHeapPriorityQueue(int capacity, FloatComparator c2) {
        if (capacity > 0) {
            this.heap = new float[capacity];
        }
        this.c = c2;
    }

    public FloatHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public FloatHeapPriorityQueue(FloatComparator c2) {
        this(0, c2);
    }

    public FloatHeapPriorityQueue() {
        this(0, null);
    }

    public FloatHeapPriorityQueue(float[] a2, int size, FloatComparator c2) {
        this(c2);
        this.heap = a2;
        this.size = size;
        FloatHeaps.makeHeap(a2, size, c2);
    }

    public FloatHeapPriorityQueue(float[] a2, FloatComparator c2) {
        this(a2, a2.length, c2);
    }

    public FloatHeapPriorityQueue(float[] a2, int size) {
        this(a2, size, null);
    }

    public FloatHeapPriorityQueue(float[] a2) {
        this(a2, a2.length);
    }

    public FloatHeapPriorityQueue(FloatCollection collection, FloatComparator c2) {
        this(collection.toFloatArray(), c2);
    }

    public FloatHeapPriorityQueue(FloatCollection collection) {
        this(collection, (FloatComparator)null);
    }

    public FloatHeapPriorityQueue(Collection<? extends Float> collection, FloatComparator c2) {
        this(collection.size(), c2);
        Iterator<? extends Float> iterator = collection.iterator();
        int size = collection.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.heap[i2] = iterator.next().floatValue();
        }
    }

    public FloatHeapPriorityQueue(Collection<? extends Float> collection) {
        this(collection, null);
    }

    @Override
    public void enqueue(float x2) {
        if (this.size == this.heap.length) {
            this.heap = FloatArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x2;
        FloatHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public float dequeueFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        float result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            FloatHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public float firstFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        FloatHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = FloatArrays.trim(this.heap, this.size);
    }

    @Override
    public FloatComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.heap.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeFloat(this.heap[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.heap = new float[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.heap[i2] = s2.readFloat();
        }
    }
}

