/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.floats.AbstractFloatBigList;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatBigList;
import it.unimi.dsi.fastutil.floats.FloatBigListIterator;
import it.unimi.dsi.fastutil.floats.FloatBigListIterators;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollections;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public final class FloatBigLists {
    public static final EmptyBigList EMPTY_BIG_LIST = new EmptyBigList();

    private FloatBigLists() {
    }

    public static FloatBigList shuffle(FloatBigList l2, Random random) {
        long i2 = l2.size64();
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            float t2 = l2.getFloat(i2);
            l2.set(i2, l2.getFloat(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static FloatBigList singleton(float element) {
        return new Singleton(element);
    }

    public static FloatBigList singleton(Object element) {
        return new Singleton(((Float)element).floatValue());
    }

    public static FloatBigList synchronize(FloatBigList l2) {
        return new SynchronizedBigList(l2);
    }

    public static FloatBigList synchronize(FloatBigList l2, Object sync) {
        return new SynchronizedBigList(l2, sync);
    }

    public static FloatBigList unmodifiable(FloatBigList l2) {
        return new UnmodifiableBigList(l2);
    }

    public static FloatBigList asBigList(FloatList list) {
        return new ListBigList(list);
    }

    public static class ListBigList
    extends AbstractFloatBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final FloatList list;

        protected ListBigList(FloatList list) {
            this.list = list;
        }

        private int intIndex(long index) {
            if (index >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big list is restricted to 32-bit indices");
            }
            return (int)index;
        }

        @Override
        public long size64() {
            return this.list.size();
        }

        @Override
        public void size(long size) {
            this.list.size(this.intIndex(size));
        }

        @Override
        public FloatBigListIterator iterator() {
            return FloatBigListIterators.asBigListIterator(this.list.iterator());
        }

        @Override
        public FloatBigListIterator listIterator() {
            return FloatBigListIterators.asBigListIterator(this.list.listIterator());
        }

        @Override
        public FloatBigListIterator listIterator(long index) {
            return FloatBigListIterators.asBigListIterator(this.list.listIterator(this.intIndex(index)));
        }

        @Override
        public boolean addAll(long index, Collection<? extends Float> c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public FloatBigList subList(long from, long to) {
            return new ListBigList(this.list.subList(this.intIndex(from), this.intIndex(to)));
        }

        @Override
        public boolean contains(float key) {
            return this.list.contains(key);
        }

        @Override
        public float[] toFloatArray() {
            return this.list.toFloatArray();
        }

        @Override
        public void removeElements(long from, long to) {
            this.list.removeElements(this.intIndex(from), this.intIndex(to));
        }

        @Override
        @Deprecated
        public float[] toFloatArray(float[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean addAll(long index, FloatCollection c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(FloatCollection c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean addAll(long index, FloatBigList c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(FloatBigList c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean containsAll(FloatCollection c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean removeAll(FloatCollection c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(FloatCollection c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void add(long index, float key) {
            this.list.add(this.intIndex(index), key);
        }

        @Override
        public boolean add(float key) {
            return this.list.add(key);
        }

        @Override
        public float getFloat(long index) {
            return this.list.getFloat(this.intIndex(index));
        }

        @Override
        public long indexOf(float k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(float k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public float removeFloat(long index) {
            return this.list.removeFloat(this.intIndex(index));
        }

        @Override
        public float set(long index, float k2) {
            return this.list.set(this.intIndex(index), k2);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends Float> c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static class UnmodifiableBigList
    extends FloatCollections.UnmodifiableCollection
    implements FloatBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final FloatBigList list;

        protected UnmodifiableBigList(FloatBigList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public float getFloat(long i2) {
            return this.list.getFloat(i2);
        }

        @Override
        public float set(long i2, float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long i2, float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float removeFloat(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(float k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(float k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(long index, Collection<? extends Float> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(long from, float[][] a2, long offset, long length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, float[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, float[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void size(long size) {
            this.list.size(size);
        }

        @Override
        public long size64() {
            return this.list.size64();
        }

        @Override
        public FloatBigListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public FloatBigListIterator listIterator() {
            return FloatBigListIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public FloatBigListIterator listIterator(long i2) {
            return FloatBigListIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        public FloatBigList subList(long from, long to) {
            return FloatBigLists.unmodifiable(this.list.subList(from, to));
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.list.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int compareTo(BigList<? extends Float> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(long index, FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(FloatBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long index, FloatBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Float get(long i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(long i2, Float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Float set(long index, Float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Float remove(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedBigList
    extends FloatCollections.SynchronizedCollection
    implements FloatBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final FloatBigList list;

        protected SynchronizedBigList(FloatBigList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedBigList(FloatBigList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getFloat(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getFloat(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float set(long i2, float k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long i2, float k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float removeFloat(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeFloat(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long indexOf(float k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastIndexOf(float k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, Collection<? extends Float> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(long from, float[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, float[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, float[][] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void size(long size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size64() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.size64();
            }
        }

        @Override
        public FloatBigListIterator iterator() {
            return this.list.listIterator();
        }

        @Override
        public FloatBigListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public FloatBigListIterator listIterator(long i2) {
            return this.list.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FloatBigList subList(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                return FloatBigLists.synchronize(this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.list.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(BigList<? extends Float> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, FloatCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, FloatBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(FloatBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(long i2, Float k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Float get(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Float set(long index, Float k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Float remove(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }
    }

    public static class Singleton
    extends AbstractFloatBigList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final float element;

        protected Singleton(float element) {
            this.element = element;
        }

        @Override
        public float getFloat(long i2) {
            if (i2 == 0L) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float removeFloat(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(float k2) {
            return Float.floatToIntBits(k2) == Float.floatToIntBits(this.element);
        }

        @Override
        public float[] toFloatArray() {
            float[] a2 = new float[]{this.element};
            return a2;
        }

        @Override
        public FloatBigListIterator listIterator() {
            return FloatBigListIterators.singleton(this.element);
        }

        @Override
        public FloatBigListIterator listIterator(long i2) {
            if (i2 > 1L || i2 < 0L) {
                throw new IndexOutOfBoundsException();
            }
            FloatBigListIterator l2 = this.listIterator();
            if (i2 == 1L) {
                l2.nextFloat();
            }
            return l2;
        }

        @Override
        public FloatBigList subList(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0L || to != 1L) {
                return EMPTY_BIG_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Float> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Float> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(FloatBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, FloatBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 1L;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyBigList
    extends FloatCollections.EmptyCollection
    implements FloatBigList,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigList() {
        }

        @Override
        public float getFloat(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float removeFloat(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long index, float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float set(long index, float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(float k2) {
            return -1L;
        }

        @Override
        public long lastIndexOf(float k2) {
            return -1L;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Float> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(FloatBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, FloatCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, FloatBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(long index, Float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Float get(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public Float set(long index, Float k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Float remove(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object k2) {
            return -1L;
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object k2) {
            return -1L;
        }

        @Override
        public FloatBigListIterator listIterator() {
            return FloatBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public FloatBigListIterator iterator() {
            return FloatBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public FloatBigListIterator listIterator(long i2) {
            if (i2 == 0L) {
                return FloatBigListIterators.EMPTY_BIG_LIST_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        public FloatBigList subList(long from, long to) {
            if (from == 0L && to == 0L) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void getElements(long from, float[][] a2, long offset, long length) {
            FloatBigArrays.ensureOffsetLength(a2, offset, length);
            if (from != 0L) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, float[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, float[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(long s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 0L;
        }

        @Override
        public int compareTo(BigList<? extends Float> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_BIG_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof BigList && ((BigList)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST;
        }
    }
}

