/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatBigListIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class FloatBigListIterators {
    public static final EmptyBigListIterator EMPTY_BIG_LIST_ITERATOR = new EmptyBigListIterator();

    private FloatBigListIterators() {
    }

    public static FloatBigListIterator singleton(float element) {
        return new SingletonBigListIterator(element);
    }

    public static FloatBigListIterator unmodifiable(FloatBigListIterator i2) {
        return new UnmodifiableBigListIterator(i2);
    }

    public static FloatBigListIterator asBigListIterator(FloatListIterator i2) {
        return new BigListIteratorListIterator(i2);
    }

    public static class BigListIteratorListIterator
    implements FloatBigListIterator {
        protected final FloatListIterator i;

        protected BigListIteratorListIterator(FloatListIterator i2) {
            this.i = i2;
        }

        private int intDisplacement(long n2) {
            if (n2 < Integer.MIN_VALUE || n2 > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big iterator is restricted to 32-bit displacements");
            }
            return (int)n2;
        }

        @Override
        public void set(float ok) {
            this.i.set(ok);
        }

        @Override
        public void add(float ok) {
            this.i.add(ok);
        }

        @Override
        public int back(int n2) {
            return this.i.back(n2);
        }

        @Override
        public long back(long n2) {
            return this.i.back(this.intDisplacement(n2));
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public int skip(int n2) {
            return this.i.skip(n2);
        }

        @Override
        public long skip(long n2) {
            return this.i.skip(this.intDisplacement(n2));
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }

        @Override
        public float previousFloat() {
            return this.i.previousFloat();
        }

        @Override
        public long nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBigListIterator
    implements FloatBigListIterator {
        protected final FloatBigListIterator i;

        public UnmodifiableBigListIterator(FloatBigListIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }

        @Override
        public float previousFloat() {
            return this.i.previousFloat();
        }

        @Override
        public long nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    private static class SingletonBigListIterator
    implements FloatBigListIterator {
        private final float element;
        private int curr;

        public SingletonBigListIterator(float element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.curr == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr == 1;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        @Override
        public long nextIndex() {
            return this.curr;
        }

        @Override
        public long previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyBigListIterator
    implements FloatBigListIterator,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigListIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public float nextFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public float previousFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public long nextIndex() {
            return 0L;
        }

        @Override
        public long previousIndex() {
            return -1L;
        }

        @Override
        public long skip(long n2) {
            return 0L;
        }

        @Override
        public long back(long n2) {
            return 0L;
        }

        public Object clone() {
            return EMPTY_BIG_LIST_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST_ITERATOR;
        }
    }
}

