/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloat2LongFunction;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2LongMap;
import it.unimi.dsi.fastutil.floats.Float2LongMaps;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractFloat2LongMap
extends AbstractFloat2LongFunction
implements Float2LongMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2LongMap() {
    }

    @Override
    public boolean containsValue(long v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(float k2) {
        Iterator i2 = this.float2LongEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Float2LongMap.Entry)i2.next()).getFloatKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k2) {
                return AbstractFloat2LongMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2LongMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Float2LongMap.Entry> i;
                    {
                        this.i = Float2LongMaps.fastIterator(AbstractFloat2LongMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2LongMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public LongCollection values() {
        return new AbstractLongCollection(){

            @Override
            public boolean contains(long k2) {
                return AbstractFloat2LongMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2LongMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Float2LongMap.Entry> i;
                    {
                        this.i = Float2LongMaps.fastIterator(AbstractFloat2LongMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Float2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Long> m2) {
        if (m2 instanceof Float2LongMap) {
            ObjectIterator<Float2LongMap.Entry> i2 = Float2LongMaps.fastIterator((Float2LongMap)m2);
            while (i2.hasNext()) {
                Float2LongMap.Entry e2 = (Float2LongMap.Entry)i2.next();
                this.put(e2.getFloatKey(), e2.getLongValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Float, ? extends Long>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Float, ? extends Long> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Float2LongMap.Entry> i2 = Float2LongMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Float2LongMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.float2LongEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Float2LongMap.Entry> i2 = Float2LongMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Float2LongMap.Entry e2 = (Float2LongMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getFloatKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getLongValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Float2LongMap.Entry> {
        protected final Float2LongMap map;

        public BasicEntrySet(Float2LongMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2LongMap.Entry) {
                Float2LongMap.Entry e2 = (Float2LongMap.Entry)o2;
                float k2 = e2.getFloatKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getLongValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k3 = ((Float)key).floatValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Long)value).longValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2LongMap.Entry) {
                Float2LongMap.Entry e2 = (Float2LongMap.Entry)o2;
                return this.map.remove(e2.getFloatKey(), e2.getLongValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k2 = ((Float)key).floatValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            long v2 = (Long)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Float2LongMap.Entry {
        protected float key;
        protected long value;

        public BasicEntry() {
        }

        public BasicEntry(Float key, Long value) {
            this.key = key.floatValue();
            this.value = value;
        }

        public BasicEntry(float key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public long getLongValue() {
            return this.value;
        }

        @Override
        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2LongMap.Entry) {
                Float2LongMap.Entry e2 = (Float2LongMap.Entry)o2;
                return Float.floatToIntBits(this.key) == Float.floatToIntBits(e2.getFloatKey()) && this.value == e2.getLongValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return Float.floatToIntBits(this.key) == Float.floatToIntBits(((Float)key).floatValue()) && this.value == (Long)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ HashCommon.long2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

