/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloat2FloatFunction;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatMaps;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractFloat2FloatMap
extends AbstractFloat2FloatFunction
implements Float2FloatMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2FloatMap() {
    }

    @Override
    public boolean containsValue(float v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(float k2) {
        Iterator i2 = this.float2FloatEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Float2FloatMap.Entry)i2.next()).getFloatKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k2) {
                return AbstractFloat2FloatMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2FloatMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2FloatMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Float2FloatMap.Entry> i;
                    {
                        this.i = Float2FloatMaps.fastIterator(AbstractFloat2FloatMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2FloatMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public FloatCollection values() {
        return new AbstractFloatCollection(){

            @Override
            public boolean contains(float k2) {
                return AbstractFloat2FloatMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2FloatMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2FloatMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Float2FloatMap.Entry> i;
                    {
                        this.i = Float2FloatMaps.fastIterator(AbstractFloat2FloatMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Float> m2) {
        if (m2 instanceof Float2FloatMap) {
            ObjectIterator<Float2FloatMap.Entry> i2 = Float2FloatMaps.fastIterator((Float2FloatMap)m2);
            while (i2.hasNext()) {
                Float2FloatMap.Entry e2 = (Float2FloatMap.Entry)i2.next();
                this.put(e2.getFloatKey(), e2.getFloatValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Float, ? extends Float>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Float, ? extends Float> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Float2FloatMap.Entry> i2 = Float2FloatMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Float2FloatMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.float2FloatEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Float2FloatMap.Entry> i2 = Float2FloatMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Float2FloatMap.Entry e2 = (Float2FloatMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getFloatKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getFloatValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Float2FloatMap.Entry> {
        protected final Float2FloatMap map;

        public BasicEntrySet(Float2FloatMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2FloatMap.Entry) {
                Float2FloatMap.Entry e2 = (Float2FloatMap.Entry)o2;
                float k2 = e2.getFloatKey();
                return this.map.containsKey(k2) && Float.floatToIntBits(this.map.get(k2)) == Float.floatToIntBits(e2.getFloatValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k3 = ((Float)key).floatValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return this.map.containsKey(k3) && Float.floatToIntBits(this.map.get(k3)) == Float.floatToIntBits(((Float)value).floatValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2FloatMap.Entry) {
                Float2FloatMap.Entry e2 = (Float2FloatMap.Entry)o2;
                return this.map.remove(e2.getFloatKey(), e2.getFloatValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k2 = ((Float)key).floatValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            float v2 = ((Float)value).floatValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Float2FloatMap.Entry {
        protected float key;
        protected float value;

        public BasicEntry() {
        }

        public BasicEntry(Float key, Float value) {
            this.key = key.floatValue();
            this.value = value.floatValue();
        }

        public BasicEntry(float key, float value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public float getFloatValue() {
            return this.value;
        }

        @Override
        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2FloatMap.Entry) {
                Float2FloatMap.Entry e2 = (Float2FloatMap.Entry)o2;
                return Float.floatToIntBits(this.key) == Float.floatToIntBits(e2.getFloatKey()) && Float.floatToIntBits(this.value) == Float.floatToIntBits(e2.getFloatValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return Float.floatToIntBits(this.key) == Float.floatToIntBits(((Float)key).floatValue()) && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)value).floatValue());
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

