/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2CharFunction;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2CharMap;
import it.unimi.dsi.fastutil.floats.Float2CharMaps;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractFloat2CharMap
extends AbstractFloat2CharFunction
implements Float2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2CharMap() {
    }

    @Override
    public boolean containsValue(char v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(float k2) {
        Iterator i2 = this.float2CharEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Float2CharMap.Entry)i2.next()).getFloatKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k2) {
                return AbstractFloat2CharMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2CharMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Float2CharMap.Entry> i;
                    {
                        this.i = Float2CharMaps.fastIterator(AbstractFloat2CharMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2CharMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k2) {
                return AbstractFloat2CharMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Float2CharMap.Entry> i;
                    {
                        this.i = Float2CharMaps.fastIterator(AbstractFloat2CharMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Float2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Character> m2) {
        if (m2 instanceof Float2CharMap) {
            ObjectIterator<Float2CharMap.Entry> i2 = Float2CharMaps.fastIterator((Float2CharMap)m2);
            while (i2.hasNext()) {
                Float2CharMap.Entry e2 = (Float2CharMap.Entry)i2.next();
                this.put(e2.getFloatKey(), e2.getCharValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Float, ? extends Character>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Float, ? extends Character> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Float2CharMap.Entry> i2 = Float2CharMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Float2CharMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.float2CharEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Float2CharMap.Entry> i2 = Float2CharMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Float2CharMap.Entry e2 = (Float2CharMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getFloatKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getCharValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Float2CharMap.Entry> {
        protected final Float2CharMap map;

        public BasicEntrySet(Float2CharMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2CharMap.Entry) {
                Float2CharMap.Entry e2 = (Float2CharMap.Entry)o2;
                float k2 = e2.getFloatKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getCharValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k3 = ((Float)key).floatValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Character)value).charValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2CharMap.Entry) {
                Float2CharMap.Entry e2 = (Float2CharMap.Entry)o2;
                return this.map.remove(e2.getFloatKey(), e2.getCharValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k2 = ((Float)key).floatValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            char v2 = ((Character)value).charValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Float2CharMap.Entry {
        protected float key;
        protected char value;

        public BasicEntry() {
        }

        public BasicEntry(Float key, Character value) {
            this.key = key.floatValue();
            this.value = value.charValue();
        }

        public BasicEntry(float key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Float2CharMap.Entry) {
                Float2CharMap.Entry e2 = (Float2CharMap.Entry)o2;
                return Float.floatToIntBits(this.key) == Float.floatToIntBits(e2.getFloatKey()) && this.value == e2.getCharValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return Float.floatToIntBits(this.key) == Float.floatToIntBits(((Float)key).floatValue()) && this.value == ((Character)value).charValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

