/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleOpenHashBigSet
extends AbstractDoubleSet
implements Serializable,
Cloneable,
Hash,
Size64 {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[][] key;
    protected transient long mask;
    protected transient int segmentMask;
    protected transient int baseMask;
    protected transient boolean containsNull;
    protected transient long n;
    protected transient long maxFill;
    protected final transient long minN;
    protected final float f;
    protected long size;

    private void initMasks() {
        this.mask = this.n - 1L;
        this.segmentMask = this.key[0].length - 1;
        this.baseMask = this.key.length - 1;
    }

    public DoubleOpenHashBigSet(long expected, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (this.n < 0L) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.bigArraySize(expected, f2);
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = DoubleBigArrays.newBigArray(this.n);
        this.initMasks();
    }

    public DoubleOpenHashBigSet(long expected) {
        this(expected, 0.75f);
    }

    public DoubleOpenHashBigSet() {
        this(16L, 0.75f);
    }

    public DoubleOpenHashBigSet(Collection<? extends Double> c2, float f2) {
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public DoubleOpenHashBigSet(Collection<? extends Double> c2) {
        this(c2, 0.75f);
    }

    public DoubleOpenHashBigSet(DoubleCollection c2, float f2) {
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public DoubleOpenHashBigSet(DoubleCollection c2) {
        this(c2, 0.75f);
    }

    public DoubleOpenHashBigSet(DoubleIterator i2, float f2) {
        this(16L, f2);
        while (i2.hasNext()) {
            this.add(i2.nextDouble());
        }
    }

    public DoubleOpenHashBigSet(DoubleIterator i2) {
        this(i2, 0.75f);
    }

    public DoubleOpenHashBigSet(Iterator<?> i2, float f2) {
        this(DoubleIterators.asDoubleIterator(i2), f2);
    }

    public DoubleOpenHashBigSet(Iterator<?> i2) {
        this(DoubleIterators.asDoubleIterator(i2));
    }

    public DoubleOpenHashBigSet(double[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0L : (long)length, f2);
        DoubleArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2[offset + i2]);
        }
    }

    public DoubleOpenHashBigSet(double[] a2, int offset, int length) {
        this(a2, offset, length, 0.75f);
    }

    public DoubleOpenHashBigSet(double[] a2, float f2) {
        this(a2, 0, a2.length, f2);
    }

    public DoubleOpenHashBigSet(double[] a2) {
        this(a2, 0.75f);
    }

    private long realSize() {
        return this.containsNull ? this.size - 1L : this.size;
    }

    private void ensureCapacity(long capacity) {
        long needed = HashCommon.bigArraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    @Override
    public boolean addAll(Collection<? extends Double> c2) {
        long size;
        long l2 = size = c2 instanceof Size64 ? ((Size64)((Object)c2)).size64() : (long)c2.size();
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(size);
        } else {
            this.ensureCapacity(this.size64() + size);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean addAll(DoubleCollection c2) {
        long size;
        long l2 = size = c2 instanceof Size64 ? ((Size64)((Object)c2)).size64() : (long)c2.size();
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(size);
        } else {
            this.ensureCapacity(this.size64() + size);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean add(double k2) {
        if (Double.doubleToLongBits(k2) == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            int displ;
            double[][] key = this.key;
            long h2 = HashCommon.mix(Double.doubleToRawLongBits(k2));
            int base = (int)((h2 & this.mask) >>> 27);
            double curr = key[base][displ = (int)(h2 & (long)this.segmentMask)];
            if (Double.doubleToLongBits(curr) != 0L) {
                if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k2)) {
                    return false;
                }
                while (Double.doubleToLongBits(curr = key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0L) {
                    if (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k2)) continue;
                    return false;
                }
            }
            key[base][displ] = k2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(2L * this.n);
        }
        return true;
    }

    protected final void shiftKeys(long pos) {
        double[][] key = this.key;
        while (true) {
            long last = pos;
            pos = last + 1L & this.mask;
            while (true) {
                if (Double.doubleToLongBits(DoubleBigArrays.get(key, pos)) == 0L) {
                    DoubleBigArrays.set(key, last, 0.0);
                    return;
                }
                long slot = HashCommon.mix(Double.doubleToRawLongBits(DoubleBigArrays.get(key, pos))) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1L & this.mask;
            }
            DoubleBigArrays.set(key, last, DoubleBigArrays.get(key, pos));
        }
    }

    private boolean removeEntry(int base, int displ) {
        --this.size;
        this.shiftKeys((long)base * 0x8000000L + (long)displ);
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 16L) {
            this.rehash(this.n / 2L);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 16L) {
            this.rehash(this.n / 2L);
        }
        return true;
    }

    @Override
    public boolean remove(double k2) {
        int displ;
        if (Double.doubleToLongBits(k2) == 0L) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        double[][] key = this.key;
        long h2 = HashCommon.mix(Double.doubleToRawLongBits(k2));
        int base = (int)((h2 & this.mask) >>> 27);
        double curr = key[base][displ = (int)(h2 & (long)this.segmentMask)];
        if (Double.doubleToLongBits(curr) == 0L) {
            return false;
        }
        if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k2)) {
            return this.removeEntry(base, displ);
        }
        do {
            if (Double.doubleToLongBits(curr = key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0L) continue;
            return false;
        } while (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k2));
        return this.removeEntry(base, displ);
    }

    @Override
    public boolean contains(double k2) {
        int displ;
        if (Double.doubleToLongBits(k2) == 0L) {
            return this.containsNull;
        }
        double[][] key = this.key;
        long h2 = HashCommon.mix(Double.doubleToRawLongBits(k2));
        int base = (int)((h2 & this.mask) >>> 27);
        double curr = key[base][displ = (int)(h2 & (long)this.segmentMask)];
        if (Double.doubleToLongBits(curr) == 0L) {
            return false;
        }
        if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k2)) {
            return true;
        }
        do {
            if (Double.doubleToLongBits(curr = key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0L) continue;
            return false;
        } while (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k2));
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0L) {
            return;
        }
        this.size = 0L;
        this.containsNull = false;
        DoubleBigArrays.fill(this.key, 0.0);
    }

    @Override
    public DoubleIterator iterator() {
        return new SetIterator();
    }

    public boolean trim() {
        long l2 = HashCommon.bigArraySize(this.size, this.f);
        if (l2 >= this.n || this.size > HashCommon.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(long n2) {
        long l2 = HashCommon.bigArraySize(n2, this.f);
        if (this.n <= l2) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(long newN) {
        double[][] key = this.key;
        double[][] newKey = DoubleBigArrays.newBigArray(newN);
        long mask = newN - 1L;
        int newSegmentMask = newKey[0].length - 1;
        int newBaseMask = newKey.length - 1;
        int base = 0;
        int displ = 0;
        long i2 = this.realSize();
        while (i2-- != 0L) {
            int d2;
            while (Double.doubleToLongBits(key[base][displ]) == 0L) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            double k2 = key[base][displ];
            long h2 = HashCommon.mix(Double.doubleToRawLongBits(k2));
            int b2 = (int)((h2 & mask) >>> 27);
            if (Double.doubleToLongBits(newKey[b2][d2 = (int)(h2 & (long)newSegmentMask)]) != 0L) {
                while (Double.doubleToLongBits(newKey[b2 = b2 + ((d2 = d2 + 1 & newSegmentMask) == 0 ? 1 : 0) & newBaseMask][d2]) != 0L) {
                }
            }
            newKey[b2][d2] = k2;
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        this.n = newN;
        this.key = newKey;
        this.initMasks();
        this.maxFill = HashCommon.maxFill(this.n, this.f);
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public DoubleOpenHashBigSet clone() {
        DoubleOpenHashBigSet c2;
        try {
            c2 = (DoubleOpenHashBigSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.key = DoubleBigArrays.copy(this.key);
        c2.containsNull = this.containsNull;
        return c2;
    }

    @Override
    public int hashCode() {
        double[][] key = this.key;
        int h2 = 0;
        int base = 0;
        int displ = 0;
        long j2 = this.realSize();
        while (j2-- != 0L) {
            while (Double.doubleToLongBits(key[base][displ]) == 0L) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            h2 += HashCommon.double2int(key[base][displ]);
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        DoubleIterator i2 = this.iterator();
        s2.defaultWriteObject();
        long j2 = this.size;
        while (j2-- != 0L) {
            s2.writeDouble(i2.nextDouble());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.bigArraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = DoubleBigArrays.newBigArray(this.n);
        double[][] key = this.key;
        this.initMasks();
        long i2 = this.size;
        while (i2-- != 0L) {
            int displ;
            double k2 = s2.readDouble();
            if (Double.doubleToLongBits(k2) == 0L) {
                this.containsNull = true;
                continue;
            }
            long h2 = HashCommon.mix(Double.doubleToRawLongBits(k2));
            int base = (int)((h2 & this.mask) >>> 27);
            if (Double.doubleToLongBits(key[base][displ = (int)(h2 & (long)this.segmentMask)]) != 0L) {
                while (Double.doubleToLongBits(key[base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask][displ]) != 0L) {
                }
            }
            key[base][displ] = k2;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    implements DoubleIterator {
        int base;
        int displ;
        long last;
        long c;
        boolean mustReturnNull;
        DoubleArrayList wrapped;

        private SetIterator() {
            this.base = DoubleOpenHashBigSet.this.key.length;
            this.last = -1L;
            this.c = DoubleOpenHashBigSet.this.size;
            this.mustReturnNull = DoubleOpenHashBigSet.this.containsNull;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0L;
        }

        @Override
        public double nextDouble() {
            double k2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = DoubleOpenHashBigSet.this.n;
                return 0.0;
            }
            double[][] key = DoubleOpenHashBigSet.this.key;
            do {
                if (this.displ == 0 && this.base <= 0) {
                    this.last = Long.MIN_VALUE;
                    return this.wrapped.getDouble(-(--this.base) - 1);
                }
                if (this.displ-- != 0) continue;
                this.displ = key[--this.base].length - 1;
            } while (Double.doubleToLongBits(k2 = key[this.base][this.displ]) == 0L);
            this.last = (long)this.base * 0x8000000L + (long)this.displ;
            return k2;
        }

        private final void shiftKeys(long pos) {
            double[][] key = DoubleOpenHashBigSet.this.key;
            while (true) {
                double curr;
                long last = pos;
                pos = last + 1L & DoubleOpenHashBigSet.this.mask;
                while (true) {
                    if (Double.doubleToLongBits(curr = DoubleBigArrays.get(key, pos)) == 0L) {
                        DoubleBigArrays.set(key, last, 0.0);
                        return;
                    }
                    long slot = HashCommon.mix(Double.doubleToRawLongBits(curr)) & DoubleOpenHashBigSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1L & DoubleOpenHashBigSet.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new DoubleArrayList();
                    }
                    this.wrapped.add(DoubleBigArrays.get(key, pos));
                }
                DoubleBigArrays.set(key, last, curr);
            }
        }

        @Override
        public void remove() {
            if (this.last == -1L) {
                throw new IllegalStateException();
            }
            if (this.last == DoubleOpenHashBigSet.this.n) {
                DoubleOpenHashBigSet.this.containsNull = false;
            } else if (this.base >= 0) {
                this.shiftKeys(this.last);
            } else {
                DoubleOpenHashBigSet.this.remove(this.wrapped.getDouble(-this.base - 1));
                this.last = -1L;
                return;
            }
            --DoubleOpenHashBigSet.this.size;
            this.last = -1L;
        }
    }
}

