/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleHeaps;
import it.unimi.dsi.fastutil.doubles.DoublePriorityQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleHeapPriorityQueue
implements DoublePriorityQueue,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient double[] heap = DoubleArrays.EMPTY_ARRAY;
    protected int size;
    protected DoubleComparator c;

    public DoubleHeapPriorityQueue(int capacity, DoubleComparator c2) {
        if (capacity > 0) {
            this.heap = new double[capacity];
        }
        this.c = c2;
    }

    public DoubleHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public DoubleHeapPriorityQueue(DoubleComparator c2) {
        this(0, c2);
    }

    public DoubleHeapPriorityQueue() {
        this(0, null);
    }

    public DoubleHeapPriorityQueue(double[] a2, int size, DoubleComparator c2) {
        this(c2);
        this.heap = a2;
        this.size = size;
        DoubleHeaps.makeHeap(a2, size, c2);
    }

    public DoubleHeapPriorityQueue(double[] a2, DoubleComparator c2) {
        this(a2, a2.length, c2);
    }

    public DoubleHeapPriorityQueue(double[] a2, int size) {
        this(a2, size, null);
    }

    public DoubleHeapPriorityQueue(double[] a2) {
        this(a2, a2.length);
    }

    public DoubleHeapPriorityQueue(DoubleCollection collection, DoubleComparator c2) {
        this(collection.toDoubleArray(), c2);
    }

    public DoubleHeapPriorityQueue(DoubleCollection collection) {
        this(collection, (DoubleComparator)null);
    }

    public DoubleHeapPriorityQueue(Collection<? extends Double> collection, DoubleComparator c2) {
        this(collection.size(), c2);
        Iterator<? extends Double> iterator = collection.iterator();
        int size = collection.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.heap[i2] = iterator.next();
        }
    }

    public DoubleHeapPriorityQueue(Collection<? extends Double> collection) {
        this(collection, null);
    }

    @Override
    public void enqueue(double x2) {
        if (this.size == this.heap.length) {
            this.heap = DoubleArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x2;
        DoubleHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public double dequeueDouble() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        double result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            DoubleHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public double firstDouble() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        DoubleHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = DoubleArrays.trim(this.heap, this.size);
    }

    @Override
    public DoubleComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.heap.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeDouble(this.heap[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.heap = new double[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.heap[i2] = s2.readDouble();
        }
    }
}

