/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class DoubleComparators {
    public static final DoubleComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final DoubleComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private DoubleComparators() {
    }

    public static DoubleComparator oppositeComparator(DoubleComparator c2) {
        return new OppositeComparator(c2);
    }

    public static DoubleComparator asDoubleComparator(final Comparator<? super Double> c2) {
        if (c2 == null || c2 instanceof DoubleComparator) {
            return (DoubleComparator)c2;
        }
        return new DoubleComparator(){

            @Override
            public int compare(double x2, double y2) {
                return c2.compare(x2, y2);
            }

            @Override
            public int compare(Double x2, Double y2) {
                return c2.compare(x2, y2);
            }
        };
    }

    protected static class OppositeComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DoubleComparator comparator;

        protected OppositeComparator(DoubleComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(double a2, double b2) {
            return this.comparator.compare(b2, a2);
        }
    }

    protected static class OppositeImplicitComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(double a2, double b2) {
            return -Double.compare(a2, b2);
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class NaturalImplicitComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(double a2, double b2) {
            return Double.compare(a2, b2);
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }
}

