/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDouble2FloatMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Double2FloatArrayMap
extends AbstractDouble2FloatMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient double[] key;
    private transient float[] value;
    private int size;

    public Double2FloatArrayMap(double[] key, float[] value) {
        this.key = key;
        this.value = value;
        this.size = key.length;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Double2FloatArrayMap() {
        this.key = DoubleArrays.EMPTY_ARRAY;
        this.value = FloatArrays.EMPTY_ARRAY;
    }

    public Double2FloatArrayMap(int capacity) {
        this.key = new double[capacity];
        this.value = new float[capacity];
    }

    public Double2FloatArrayMap(Double2FloatMap m2) {
        this(m2.size());
        this.putAll(m2);
    }

    public Double2FloatArrayMap(Map<? extends Double, ? extends Float> m2) {
        this(m2.size());
        this.putAll(m2);
    }

    public Double2FloatArrayMap(double[] key, float[] value, int size) {
        this.key = key;
        this.value = value;
        this.size = size;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
        if (size > key.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the backing-arrays size (" + key.length + ")");
        }
    }

    public Double2FloatMap.FastEntrySet double2FloatEntrySet() {
        return new EntrySet();
    }

    private int findKey(double k2) {
        double[] key = this.key;
        int i2 = this.size;
        while (i2-- != 0) {
            if (Double.doubleToLongBits(key[i2]) != Double.doubleToLongBits(k2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public float get(double k2) {
        double[] key = this.key;
        int i2 = this.size;
        while (i2-- != 0) {
            if (Double.doubleToLongBits(key[i2]) != Double.doubleToLongBits(k2)) continue;
            return this.value[i2];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean containsKey(double k2) {
        return this.findKey(k2) != -1;
    }

    @Override
    public boolean containsValue(float v2) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (Float.floatToIntBits(this.value[i2]) != Float.floatToIntBits(v2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float put(double k2, float v2) {
        int oldKey = this.findKey(k2);
        if (oldKey != -1) {
            float oldValue = this.value[oldKey];
            this.value[oldKey] = v2;
            return oldValue;
        }
        if (this.size == this.key.length) {
            double[] newKey = new double[this.size == 0 ? 2 : this.size * 2];
            float[] newValue = new float[this.size == 0 ? 2 : this.size * 2];
            int i2 = this.size;
            while (i2-- != 0) {
                newKey[i2] = this.key[i2];
                newValue[i2] = this.value[i2];
            }
            this.key = newKey;
            this.value = newValue;
        }
        this.key[this.size] = k2;
        this.value[this.size] = v2;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public float remove(double k2) {
        int oldPos = this.findKey(k2);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        float oldValue = this.value[oldPos];
        int tail = this.size - oldPos - 1;
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, tail);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, tail);
        --this.size;
        return oldValue;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k2) {
                return Double2FloatArrayMap.this.findKey(k2) != -1;
            }

            @Override
            public boolean remove(double k2) {
                int oldPos = Double2FloatArrayMap.this.findKey(k2);
                if (oldPos == -1) {
                    return false;
                }
                int tail = Double2FloatArrayMap.this.size - oldPos - 1;
                System.arraycopy(Double2FloatArrayMap.this.key, oldPos + 1, Double2FloatArrayMap.this.key, oldPos, tail);
                System.arraycopy(Double2FloatArrayMap.this.value, oldPos + 1, Double2FloatArrayMap.this.value, oldPos, tail);
                Double2FloatArrayMap.this.size--;
                return true;
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < Double2FloatArrayMap.this.size;
                    }

                    @Override
                    public double nextDouble() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return Double2FloatArrayMap.this.key[this.pos++];
                    }

                    @Override
                    public void remove() {
                        if (this.pos == 0) {
                            throw new IllegalStateException();
                        }
                        int tail = Double2FloatArrayMap.this.size - this.pos;
                        System.arraycopy(Double2FloatArrayMap.this.key, this.pos, Double2FloatArrayMap.this.key, this.pos - 1, tail);
                        System.arraycopy(Double2FloatArrayMap.this.value, this.pos, Double2FloatArrayMap.this.value, this.pos - 1, tail);
                        Double2FloatArrayMap.this.size--;
                    }
                };
            }

            @Override
            public int size() {
                return Double2FloatArrayMap.this.size;
            }

            @Override
            public void clear() {
                Double2FloatArrayMap.this.clear();
            }
        };
    }

    @Override
    public FloatCollection values() {
        return new AbstractFloatCollection(){

            @Override
            public boolean contains(float v2) {
                return Double2FloatArrayMap.this.containsValue(v2);
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < Double2FloatArrayMap.this.size;
                    }

                    @Override
                    public float nextFloat() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return Double2FloatArrayMap.this.value[this.pos++];
                    }

                    @Override
                    public void remove() {
                        if (this.pos == 0) {
                            throw new IllegalStateException();
                        }
                        int tail = Double2FloatArrayMap.this.size - this.pos;
                        System.arraycopy(Double2FloatArrayMap.this.key, this.pos, Double2FloatArrayMap.this.key, this.pos - 1, tail);
                        System.arraycopy(Double2FloatArrayMap.this.value, this.pos, Double2FloatArrayMap.this.value, this.pos - 1, tail);
                        Double2FloatArrayMap.this.size--;
                    }
                };
            }

            @Override
            public int size() {
                return Double2FloatArrayMap.this.size;
            }

            @Override
            public void clear() {
                Double2FloatArrayMap.this.clear();
            }
        };
    }

    public Double2FloatArrayMap clone() {
        Double2FloatArrayMap c2;
        try {
            c2 = (Double2FloatArrayMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.key = (double[])this.key.clone();
        c2.value = (float[])this.value.clone();
        return c2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeDouble(this.key[i2]);
            s2.writeFloat(this.value[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.key = new double[this.size];
        this.value = new float[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.key[i2] = s2.readDouble();
            this.value[i2] = s2.readFloat();
        }
    }

    private final class EntrySet
    extends AbstractObjectSet<Double2FloatMap.Entry>
    implements Double2FloatMap.FastEntrySet {
        private EntrySet() {
        }

        @Override
        public ObjectIterator<Double2FloatMap.Entry> iterator() {
            return new ObjectIterator<Double2FloatMap.Entry>(){
                int curr = -1;
                int next = 0;

                @Override
                public boolean hasNext() {
                    return this.next < Double2FloatArrayMap.this.size;
                }

                @Override
                public Double2FloatMap.Entry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.curr = this.next;
                    return new AbstractDouble2FloatMap.BasicEntry(Double2FloatArrayMap.this.key[this.curr], Double2FloatArrayMap.this.value[this.next++]);
                }

                @Override
                public void remove() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    this.curr = -1;
                    int tail = Double2FloatArrayMap.this.size-- - this.next--;
                    System.arraycopy(Double2FloatArrayMap.this.key, this.next + 1, Double2FloatArrayMap.this.key, this.next, tail);
                    System.arraycopy(Double2FloatArrayMap.this.value, this.next + 1, Double2FloatArrayMap.this.value, this.next, tail);
                }
            };
        }

        @Override
        public ObjectIterator<Double2FloatMap.Entry> fastIterator() {
            return new ObjectIterator<Double2FloatMap.Entry>(){
                int next = 0;
                int curr = -1;
                final AbstractDouble2FloatMap.BasicEntry entry = new AbstractDouble2FloatMap.BasicEntry();

                @Override
                public boolean hasNext() {
                    return this.next < Double2FloatArrayMap.this.size;
                }

                @Override
                public Double2FloatMap.Entry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.curr = this.next;
                    this.entry.key = Double2FloatArrayMap.this.key[this.curr];
                    this.entry.value = Double2FloatArrayMap.this.value[this.next++];
                    return this.entry;
                }

                @Override
                public void remove() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    this.curr = -1;
                    int tail = Double2FloatArrayMap.this.size-- - this.next--;
                    System.arraycopy(Double2FloatArrayMap.this.key, this.next + 1, Double2FloatArrayMap.this.key, this.next, tail);
                    System.arraycopy(Double2FloatArrayMap.this.value, this.next + 1, Double2FloatArrayMap.this.value, this.next, tail);
                }
            };
        }

        @Override
        public int size() {
            return Double2FloatArrayMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            if (e2.getKey() == null || !(e2.getKey() instanceof Double)) {
                return false;
            }
            if (e2.getValue() == null || !(e2.getValue() instanceof Float)) {
                return false;
            }
            double k2 = (Double)e2.getKey();
            return Double2FloatArrayMap.this.containsKey(k2) && Float.floatToIntBits(Double2FloatArrayMap.this.get(k2)) == Float.floatToIntBits(((Float)e2.getValue()).floatValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            if (e2.getKey() == null || !(e2.getKey() instanceof Double)) {
                return false;
            }
            if (e2.getValue() == null || !(e2.getValue() instanceof Float)) {
                return false;
            }
            double k2 = (Double)e2.getKey();
            float v2 = ((Float)e2.getValue()).floatValue();
            int oldPos = Double2FloatArrayMap.this.findKey(k2);
            if (oldPos == -1 || Float.floatToIntBits(v2) != Float.floatToIntBits(Double2FloatArrayMap.this.value[oldPos])) {
                return false;
            }
            int tail = Double2FloatArrayMap.this.size - oldPos - 1;
            System.arraycopy(Double2FloatArrayMap.this.key, oldPos + 1, Double2FloatArrayMap.this.key, oldPos, tail);
            System.arraycopy(Double2FloatArrayMap.this.value, oldPos + 1, Double2FloatArrayMap.this.value, oldPos, tail);
            Double2FloatArrayMap.this.size--;
            return true;
        }
    }
}

