/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import java.util.AbstractCollection;

public abstract class AbstractDoubleCollection
extends AbstractCollection<Double>
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    public abstract DoubleIterator iterator();

    @Override
    public boolean add(double k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(double k2) {
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextDouble()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(double k2) {
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextDouble()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Double key) {
        return DoubleCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return DoubleCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return DoubleCollection.super.remove(key);
    }

    @Override
    public double[] toArray(double[] a2) {
        if (a2 == null || a2.length < this.size()) {
            a2 = new double[this.size()];
        }
        DoubleIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public double[] toDoubleArray() {
        return this.toArray((double[])null);
    }

    @Override
    @Deprecated
    public double[] toDoubleArray(double[] a2) {
        return this.toArray(a2);
    }

    @Override
    public boolean addAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean containsAll(DoubleCollection c2) {
        DoubleIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c2.contains(i2.nextDouble())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        DoubleIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            double k2 = i2.nextDouble();
            s2.append(String.valueOf(k2));
        }
        s2.append("}");
        return s2.toString();
    }
}

