/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ReferenceFunction;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2ReferenceMap;
import it.unimi.dsi.fastutil.doubles.Double2ReferenceMaps;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractDouble2ReferenceMap<V>
extends AbstractDouble2ReferenceFunction<V>
implements Double2ReferenceMap<V>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2ReferenceMap() {
    }

    @Override
    public boolean containsValue(Object v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(double k2) {
        Iterator i2 = this.double2ReferenceEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Double2ReferenceMap.Entry)i2.next()).getDoubleKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k2) {
                return AbstractDouble2ReferenceMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2ReferenceMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Double2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Double2ReferenceMaps.fastIterator(AbstractDouble2ReferenceMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Double2ReferenceMap.Entry)this.i.next()).getDoubleKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ReferenceCollection<V> values() {
        return new AbstractReferenceCollection<V>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractDouble2ReferenceMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2ReferenceMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    private final ObjectIterator<Double2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Double2ReferenceMaps.fastIterator(AbstractDouble2ReferenceMap.this);
                    }

                    @Override
                    public V next() {
                        return ((Double2ReferenceMap.Entry)this.i.next()).getValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Double, ? extends V> m2) {
        if (m2 instanceof Double2ReferenceMap) {
            ObjectIterator i2 = Double2ReferenceMaps.fastIterator((Double2ReferenceMap)m2);
            while (i2.hasNext()) {
                Double2ReferenceMap.Entry e2 = (Double2ReferenceMap.Entry)i2.next();
                this.put(e2.getDoubleKey(), e2.getValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<Double, V>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<Double, V> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Double2ReferenceMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Double2ReferenceMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.double2ReferenceEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Double2ReferenceMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Double2ReferenceMap.Entry e2 = (Double2ReferenceMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getDoubleKey()));
            s2.append("=>");
            if (this == e2.getValue()) {
                s2.append("(this map)");
                continue;
            }
            s2.append(String.valueOf(e2.getValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<V>
    extends AbstractObjectSet<Double2ReferenceMap.Entry<V>> {
        protected final Double2ReferenceMap<V> map;

        public BasicEntrySet(Double2ReferenceMap<V> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2ReferenceMap.Entry) {
                Double2ReferenceMap.Entry e2 = (Double2ReferenceMap.Entry)o2;
                double k2 = e2.getDoubleKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k3 = (Double)key;
            Object value = e3.getValue();
            return this.map.containsKey(k3) && this.map.get(k3) == value;
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2ReferenceMap.Entry) {
                Double2ReferenceMap.Entry e2 = (Double2ReferenceMap.Entry)o2;
                return this.map.remove(e2.getDoubleKey(), e2.getValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k2 = (Double)key;
            Object v2 = e3.getValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<V>
    implements Double2ReferenceMap.Entry<V> {
        protected double key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(Double key, V value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2ReferenceMap.Entry) {
                Double2ReferenceMap.Entry e2 = (Double2ReferenceMap.Entry)o2;
                return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(e2.getDoubleKey()) && this.value == e2.getValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            Object value = e3.getValue();
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)key) && this.value == value;
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ (this.value == null ? 0 : System.identityHashCode(this.value));
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

