/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2CharFunction;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2CharMap;
import it.unimi.dsi.fastutil.doubles.Double2CharMaps;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractDouble2CharMap
extends AbstractDouble2CharFunction
implements Double2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2CharMap() {
    }

    @Override
    public boolean containsValue(char v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(double k2) {
        Iterator i2 = this.double2CharEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Double2CharMap.Entry)i2.next()).getDoubleKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k2) {
                return AbstractDouble2CharMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2CharMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Double2CharMap.Entry> i;
                    {
                        this.i = Double2CharMaps.fastIterator(AbstractDouble2CharMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Double2CharMap.Entry)this.i.next()).getDoubleKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k2) {
                return AbstractDouble2CharMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Double2CharMap.Entry> i;
                    {
                        this.i = Double2CharMaps.fastIterator(AbstractDouble2CharMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Double2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Character> m2) {
        if (m2 instanceof Double2CharMap) {
            ObjectIterator<Double2CharMap.Entry> i2 = Double2CharMaps.fastIterator((Double2CharMap)m2);
            while (i2.hasNext()) {
                Double2CharMap.Entry e2 = (Double2CharMap.Entry)i2.next();
                this.put(e2.getDoubleKey(), e2.getCharValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Double, ? extends Character>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Double, ? extends Character> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Double2CharMap.Entry> i2 = Double2CharMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Double2CharMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.double2CharEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Double2CharMap.Entry> i2 = Double2CharMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Double2CharMap.Entry e2 = (Double2CharMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getDoubleKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getCharValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Double2CharMap.Entry> {
        protected final Double2CharMap map;

        public BasicEntrySet(Double2CharMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2CharMap.Entry) {
                Double2CharMap.Entry e2 = (Double2CharMap.Entry)o2;
                double k2 = e2.getDoubleKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getCharValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k3 = (Double)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Character)value).charValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2CharMap.Entry) {
                Double2CharMap.Entry e2 = (Double2CharMap.Entry)o2;
                return this.map.remove(e2.getDoubleKey(), e2.getCharValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k2 = (Double)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            char v2 = ((Character)value).charValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Double2CharMap.Entry {
        protected double key;
        protected char value;

        public BasicEntry() {
        }

        public BasicEntry(Double key, Character value) {
            this.key = key;
            this.value = value.charValue();
        }

        public BasicEntry(double key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2CharMap.Entry) {
                Double2CharMap.Entry e2 = (Double2CharMap.Entry)o2;
                return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(e2.getDoubleKey()) && this.value == e2.getCharValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)key) && this.value == ((Character)value).charValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

