/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2BooleanFunction;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2BooleanMap;
import it.unimi.dsi.fastutil.doubles.Double2BooleanMaps;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractDouble2BooleanMap
extends AbstractDouble2BooleanFunction
implements Double2BooleanMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2BooleanMap() {
    }

    @Override
    public boolean containsValue(boolean v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(double k2) {
        Iterator i2 = this.double2BooleanEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Double2BooleanMap.Entry)i2.next()).getDoubleKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k2) {
                return AbstractDouble2BooleanMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2BooleanMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Double2BooleanMap.Entry> i;
                    {
                        this.i = Double2BooleanMaps.fastIterator(AbstractDouble2BooleanMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Double2BooleanMap.Entry)this.i.next()).getDoubleKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k2) {
                return AbstractDouble2BooleanMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Double2BooleanMap.Entry> i;
                    {
                        this.i = Double2BooleanMaps.fastIterator(AbstractDouble2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Double2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Boolean> m2) {
        if (m2 instanceof Double2BooleanMap) {
            ObjectIterator<Double2BooleanMap.Entry> i2 = Double2BooleanMaps.fastIterator((Double2BooleanMap)m2);
            while (i2.hasNext()) {
                Double2BooleanMap.Entry e2 = (Double2BooleanMap.Entry)i2.next();
                this.put(e2.getDoubleKey(), e2.getBooleanValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Double, ? extends Boolean>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Double, ? extends Boolean> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Double2BooleanMap.Entry> i2 = Double2BooleanMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Double2BooleanMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.double2BooleanEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Double2BooleanMap.Entry> i2 = Double2BooleanMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Double2BooleanMap.Entry e2 = (Double2BooleanMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getDoubleKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getBooleanValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Double2BooleanMap.Entry> {
        protected final Double2BooleanMap map;

        public BasicEntrySet(Double2BooleanMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2BooleanMap.Entry) {
                Double2BooleanMap.Entry e2 = (Double2BooleanMap.Entry)o2;
                double k2 = e2.getDoubleKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k3 = (Double)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Boolean)value).booleanValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2BooleanMap.Entry) {
                Double2BooleanMap.Entry e2 = (Double2BooleanMap.Entry)o2;
                return this.map.remove(e2.getDoubleKey(), e2.getBooleanValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k2 = (Double)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            boolean v2 = (Boolean)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Double2BooleanMap.Entry {
        protected double key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(Double key, Boolean value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, boolean value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Double2BooleanMap.Entry) {
                Double2BooleanMap.Entry e2 = (Double2BooleanMap.Entry)o2;
                return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(e2.getDoubleKey()) && this.value == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)key) && this.value == (Boolean)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

