/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharHeaps;
import it.unimi.dsi.fastutil.chars.CharPriorityQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CharHeapPriorityQueue
implements CharPriorityQueue,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient char[] heap = CharArrays.EMPTY_ARRAY;
    protected int size;
    protected CharComparator c;

    public CharHeapPriorityQueue(int capacity, CharComparator c2) {
        if (capacity > 0) {
            this.heap = new char[capacity];
        }
        this.c = c2;
    }

    public CharHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public CharHeapPriorityQueue(CharComparator c2) {
        this(0, c2);
    }

    public CharHeapPriorityQueue() {
        this(0, null);
    }

    public CharHeapPriorityQueue(char[] a2, int size, CharComparator c2) {
        this(c2);
        this.heap = a2;
        this.size = size;
        CharHeaps.makeHeap(a2, size, c2);
    }

    public CharHeapPriorityQueue(char[] a2, CharComparator c2) {
        this(a2, a2.length, c2);
    }

    public CharHeapPriorityQueue(char[] a2, int size) {
        this(a2, size, null);
    }

    public CharHeapPriorityQueue(char[] a2) {
        this(a2, a2.length);
    }

    public CharHeapPriorityQueue(CharCollection collection, CharComparator c2) {
        this(collection.toCharArray(), c2);
    }

    public CharHeapPriorityQueue(CharCollection collection) {
        this(collection, (CharComparator)null);
    }

    public CharHeapPriorityQueue(Collection<? extends Character> collection, CharComparator c2) {
        this(collection.size(), c2);
        Iterator<? extends Character> iterator = collection.iterator();
        int size = collection.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.heap[i2] = iterator.next().charValue();
        }
    }

    public CharHeapPriorityQueue(Collection<? extends Character> collection) {
        this(collection, null);
    }

    @Override
    public void enqueue(char x2) {
        if (this.size == this.heap.length) {
            this.heap = CharArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x2;
        CharHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public char dequeueChar() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        char result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            CharHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public char firstChar() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        CharHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = CharArrays.trim(this.heap, this.size);
    }

    @Override
    public CharComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.heap.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeChar(this.heap[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.heap = new char[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.heap[i2] = s2.readChar();
        }
    }
}

