/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class CharComparators {
    public static final CharComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final CharComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private CharComparators() {
    }

    public static CharComparator oppositeComparator(CharComparator c2) {
        return new OppositeComparator(c2);
    }

    public static CharComparator asCharComparator(final Comparator<? super Character> c2) {
        if (c2 == null || c2 instanceof CharComparator) {
            return (CharComparator)c2;
        }
        return new CharComparator(){

            @Override
            public int compare(char x2, char y2) {
                return c2.compare(Character.valueOf(x2), Character.valueOf(y2));
            }

            @Override
            public int compare(Character x2, Character y2) {
                return c2.compare(x2, y2);
            }
        };
    }

    protected static class OppositeComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final CharComparator comparator;

        protected OppositeComparator(CharComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(char a2, char b2) {
            return this.comparator.compare(b2, a2);
        }
    }

    protected static class OppositeImplicitComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(char a2, char b2) {
            return -Character.compare(a2, b2);
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class NaturalImplicitComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(char a2, char b2) {
            return Character.compare(a2, b2);
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }
}

