/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharBigList;
import it.unimi.dsi.fastutil.chars.CharBigArrays;
import it.unimi.dsi.fastutil.chars.CharBigList;
import it.unimi.dsi.fastutil.chars.CharBigListIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CharBigArrayBigList
extends AbstractCharBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected transient char[][] a;
    protected long size;

    protected CharBigArrayBigList(char[][] a2, boolean dummy) {
        this.a = a2;
    }

    public CharBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0L ? CharBigArrays.EMPTY_BIG_ARRAY : CharBigArrays.newBigArray(capacity);
    }

    public CharBigArrayBigList() {
        this.a = CharBigArrays.DEFAULT_EMPTY_BIG_ARRAY;
    }

    public CharBigArrayBigList(CharCollection c2) {
        this(c2.size());
        CharIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            this.add(i2.nextChar());
        }
    }

    public CharBigArrayBigList(CharBigList l2) {
        this(l2.size64());
        this.size = l2.size64();
        l2.getElements(0L, this.a, 0L, this.size);
    }

    public CharBigArrayBigList(char[][] a2) {
        this(a2, 0L, CharBigArrays.length(a2));
    }

    public CharBigArrayBigList(char[][] a2, long offset, long length) {
        this(length);
        CharBigArrays.copy(a2, offset, this.a, 0L, length);
        this.size = length;
    }

    public CharBigArrayBigList(Iterator<? extends Character> i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.next().charValue());
        }
    }

    public CharBigArrayBigList(CharIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextChar());
        }
    }

    public char[][] elements() {
        return this.a;
    }

    public static CharBigArrayBigList wrap(char[][] a2, long length) {
        if (length > CharBigArrays.length(a2)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + CharBigArrays.length(a2) + ")");
        }
        CharBigArrayBigList l2 = new CharBigArrayBigList(a2, false);
        l2.size = length;
        return l2;
    }

    public static CharBigArrayBigList wrap(char[][] a2) {
        return CharBigArrayBigList.wrap(a2, CharBigArrays.length(a2));
    }

    public void ensureCapacity(long capacity) {
        if (capacity <= (long)this.a.length || this.a == CharBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            return;
        }
        this.a = CharBigArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= CharBigArrays.length(this.a));
    }

    private void grow(long capacity) {
        long oldLength = CharBigArrays.length(this.a);
        if (capacity <= oldLength) {
            return;
        }
        if (this.a != CharBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            capacity = Math.max(oldLength + (oldLength >> 1), capacity);
        } else if (capacity < 10L) {
            capacity = 10L;
        }
        this.a = CharBigArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= CharBigArrays.length(this.a));
    }

    @Override
    public void add(long index, char k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            CharBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        CharBigArrays.set(this.a, index, k2);
        ++this.size;
        assert (this.size <= CharBigArrays.length(this.a));
    }

    @Override
    public boolean add(char k2) {
        this.grow(this.size + 1L);
        CharBigArrays.set(this.a, this.size++, k2);
        assert (this.size <= CharBigArrays.length(this.a));
        return true;
    }

    @Override
    public char getChar(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return CharBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(char k2) {
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (k2 != CharBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(char k2) {
        long i2 = this.size;
        while (i2-- != 0L) {
            if (k2 != CharBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public char removeChar(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = CharBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            CharBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        assert (this.size <= CharBigArrays.length(this.a));
        return old;
    }

    @Override
    public boolean rem(char k2) {
        long index = this.indexOf(k2);
        if (index == -1L) {
            return false;
        }
        this.removeChar(index);
        assert (this.size <= CharBigArrays.length(this.a));
        return true;
    }

    @Override
    public char set(long index, char k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = CharBigArrays.get(this.a, index);
        CharBigArrays.set(this.a, index, k2);
        return old;
    }

    @Override
    public boolean removeAll(CharCollection c2) {
        char[] s2 = null;
        char[] d2 = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss];
            }
            if (!c2.contains((char)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        char[] s2 = null;
        char[] d2 = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss];
            }
            if (!c2.contains(Character.valueOf((char)s2[sd]))) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0L;
        assert (this.size <= CharBigArrays.length(this.a));
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > CharBigArrays.length(this.a)) {
            this.a = CharBigArrays.forceCapacity(this.a, size, this.size);
        }
        if (size > this.size) {
            CharBigArrays.fill(this.a, this.size, size, '\u0000');
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n2) {
        long arrayLength = CharBigArrays.length(this.a);
        if (n2 >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = CharBigArrays.trim(this.a, Math.max(n2, this.size));
        assert (this.size <= CharBigArrays.length(this.a));
    }

    @Override
    public void getElements(long from, char[][] a2, long offset, long length) {
        CharBigArrays.copy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo(this.size, from, to);
        CharBigArrays.copy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(long index, char[][] a2, long offset, long length) {
        this.ensureIndex(index);
        CharBigArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        CharBigArrays.copy(this.a, index, this.a, index + length, this.size - index);
        CharBigArrays.copy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public CharBigListIterator listIterator(final long index) {
        this.ensureIndex(index);
        return new CharBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < CharBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return CharBigArrays.get(CharBigArrayBigList.this.a, this.last);
            }

            @Override
            public char previousChar() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return CharBigArrays.get(CharBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(char k2) {
                CharBigArrayBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(char k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                CharBigArrayBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                CharBigArrayBigList.this.removeChar(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public CharBigArrayBigList clone() {
        CharBigArrayBigList c2 = new CharBigArrayBigList(this.size);
        CharBigArrays.copy(this.a, 0L, c2.a, 0L, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(CharBigArrayBigList l2) {
        if (l2 == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        char[][] a1 = this.a;
        char[][] a2 = l2.a;
        while (s2-- != 0L) {
            if (CharBigArrays.get(a1, s2) == CharBigArrays.get(a2, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(CharBigArrayBigList l2) {
        long s1 = this.size64();
        long s2 = l2.size64();
        char[][] a1 = this.a;
        char[][] a2 = l2.a;
        int i2 = 0;
        while ((long)i2 < s1 && (long)i2 < s2) {
            char e2;
            char e1 = CharBigArrays.get(a1, i2);
            int r2 = Character.compare(e1, e2 = CharBigArrays.get(a2, i2));
            if (r2 != 0) {
                return r2;
            }
            ++i2;
        }
        return (long)i2 < s2 ? -1 : ((long)i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i2 = 0;
        while ((long)i2 < this.size) {
            s2.writeChar(CharBigArrays.get(this.a, i2));
            ++i2;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = CharBigArrays.newBigArray(this.size);
        int i2 = 0;
        while ((long)i2 < this.size) {
            CharBigArrays.set(this.a, i2, s2.readChar());
            ++i2;
        }
    }
}

