/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractChar2ObjectFunction;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMaps;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractChar2ObjectMap<V>
extends AbstractChar2ObjectFunction<V>
implements Char2ObjectMap<V>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2ObjectMap() {
    }

    @Override
    public boolean containsValue(Object v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(char k2) {
        Iterator i2 = this.char2ObjectEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Char2ObjectMap.Entry)i2.next()).getCharKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k2) {
                return AbstractChar2ObjectMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractChar2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ObjectMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2ObjectMap.Entry<V>> i;
                    {
                        this.i = Char2ObjectMaps.fastIterator(AbstractChar2ObjectMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2ObjectMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ObjectCollection<V> values() {
        return new AbstractObjectCollection<V>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractChar2ObjectMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractChar2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ObjectMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    private final ObjectIterator<Char2ObjectMap.Entry<V>> i;
                    {
                        this.i = Char2ObjectMaps.fastIterator(AbstractChar2ObjectMap.this);
                    }

                    @Override
                    public V next() {
                        return ((Char2ObjectMap.Entry)this.i.next()).getValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends V> m2) {
        if (m2 instanceof Char2ObjectMap) {
            ObjectIterator i2 = Char2ObjectMaps.fastIterator((Char2ObjectMap)m2);
            while (i2.hasNext()) {
                Char2ObjectMap.Entry e2 = (Char2ObjectMap.Entry)i2.next();
                this.put(e2.getCharKey(), e2.getValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<Character, V>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<Character, V> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Char2ObjectMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Char2ObjectMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.char2ObjectEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Char2ObjectMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Char2ObjectMap.Entry e2 = (Char2ObjectMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getCharKey()));
            s2.append("=>");
            if (this == e2.getValue()) {
                s2.append("(this map)");
                continue;
            }
            s2.append(String.valueOf(e2.getValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<V>
    extends AbstractObjectSet<Char2ObjectMap.Entry<V>> {
        protected final Char2ObjectMap<V> map;

        public BasicEntrySet(Char2ObjectMap<V> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2ObjectMap.Entry) {
                Char2ObjectMap.Entry e2 = (Char2ObjectMap.Entry)o2;
                char k2 = e2.getCharKey();
                return this.map.containsKey(k2) && Objects.equals(this.map.get(k2), e2.getValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k3 = ((Character)key).charValue();
            Object value = e3.getValue();
            return this.map.containsKey(k3) && Objects.equals(this.map.get(k3), value);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2ObjectMap.Entry) {
                Char2ObjectMap.Entry e2 = (Char2ObjectMap.Entry)o2;
                return this.map.remove(e2.getCharKey(), e2.getValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k2 = ((Character)key).charValue();
            Object v2 = e3.getValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<V>
    implements Char2ObjectMap.Entry<V> {
        protected char key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, V value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2ObjectMap.Entry) {
                Char2ObjectMap.Entry e2 = (Char2ObjectMap.Entry)o2;
                return this.key == e2.getCharKey() && Objects.equals(this.value, e2.getValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value = e3.getValue();
            return this.key == ((Character)key).charValue() && Objects.equals(this.value, value);
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

