/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractChar2IntFunction;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntMaps;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChar2IntMap
extends AbstractChar2IntFunction
implements Char2IntMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2IntMap() {
    }

    @Override
    public boolean containsValue(int v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(char k2) {
        Iterator i2 = this.char2IntEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Char2IntMap.Entry)i2.next()).getCharKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k2) {
                return AbstractChar2IntMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractChar2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2IntMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2IntMap.Entry> i;
                    {
                        this.i = Char2IntMaps.fastIterator(AbstractChar2IntMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2IntMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public boolean contains(int k2) {
                return AbstractChar2IntMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractChar2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2IntMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Char2IntMap.Entry> i;
                    {
                        this.i = Char2IntMaps.fastIterator(AbstractChar2IntMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Char2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Integer> m2) {
        if (m2 instanceof Char2IntMap) {
            ObjectIterator<Char2IntMap.Entry> i2 = Char2IntMaps.fastIterator((Char2IntMap)m2);
            while (i2.hasNext()) {
                Char2IntMap.Entry e2 = (Char2IntMap.Entry)i2.next();
                this.put(e2.getCharKey(), e2.getIntValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Character, ? extends Integer>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Character, ? extends Integer> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Char2IntMap.Entry> i2 = Char2IntMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Char2IntMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.char2IntEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Char2IntMap.Entry> i2 = Char2IntMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Char2IntMap.Entry e2 = (Char2IntMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getCharKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getIntValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Char2IntMap.Entry> {
        protected final Char2IntMap map;

        public BasicEntrySet(Char2IntMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2IntMap.Entry) {
                Char2IntMap.Entry e2 = (Char2IntMap.Entry)o2;
                char k2 = e2.getCharKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getIntValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k3 = ((Character)key).charValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Integer)value).intValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2IntMap.Entry) {
                Char2IntMap.Entry e2 = (Char2IntMap.Entry)o2;
                return this.map.remove(e2.getCharKey(), e2.getIntValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k2 = ((Character)key).charValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            int v2 = (Integer)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Char2IntMap.Entry {
        protected char key;
        protected int value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, Integer value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public int getIntValue() {
            return this.value;
        }

        @Override
        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2IntMap.Entry) {
                Char2IntMap.Entry e2 = (Char2IntMap.Entry)o2;
                return this.key == e2.getCharKey() && this.value == e2.getIntValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return this.key == ((Character)key).charValue() && this.value == (Integer)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

