/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractChar2DoubleFunction;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2DoubleMap;
import it.unimi.dsi.fastutil.chars.Char2DoubleMaps;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChar2DoubleMap
extends AbstractChar2DoubleFunction
implements Char2DoubleMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2DoubleMap() {
    }

    @Override
    public boolean containsValue(double v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(char k2) {
        Iterator i2 = this.char2DoubleEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Char2DoubleMap.Entry)i2.next()).getCharKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k2) {
                return AbstractChar2DoubleMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractChar2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2DoubleMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2DoubleMap.Entry> i;
                    {
                        this.i = Char2DoubleMaps.fastIterator(AbstractChar2DoubleMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2DoubleMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k2) {
                return AbstractChar2DoubleMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractChar2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Char2DoubleMap.Entry> i;
                    {
                        this.i = Char2DoubleMaps.fastIterator(AbstractChar2DoubleMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Char2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Double> m2) {
        if (m2 instanceof Char2DoubleMap) {
            ObjectIterator<Char2DoubleMap.Entry> i2 = Char2DoubleMaps.fastIterator((Char2DoubleMap)m2);
            while (i2.hasNext()) {
                Char2DoubleMap.Entry e2 = (Char2DoubleMap.Entry)i2.next();
                this.put(e2.getCharKey(), e2.getDoubleValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Character, ? extends Double>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Character, ? extends Double> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Char2DoubleMap.Entry> i2 = Char2DoubleMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Char2DoubleMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.char2DoubleEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Char2DoubleMap.Entry> i2 = Char2DoubleMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Char2DoubleMap.Entry e2 = (Char2DoubleMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getCharKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getDoubleValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Char2DoubleMap.Entry> {
        protected final Char2DoubleMap map;

        public BasicEntrySet(Char2DoubleMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2DoubleMap.Entry) {
                Char2DoubleMap.Entry e2 = (Char2DoubleMap.Entry)o2;
                char k2 = e2.getCharKey();
                return this.map.containsKey(k2) && Double.doubleToLongBits(this.map.get(k2)) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k3 = ((Character)key).charValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.map.containsKey(k3) && Double.doubleToLongBits(this.map.get(k3)) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2DoubleMap.Entry) {
                Char2DoubleMap.Entry e2 = (Char2DoubleMap.Entry)o2;
                return this.map.remove(e2.getCharKey(), e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k2 = ((Character)key).charValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            double v2 = (Double)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Char2DoubleMap.Entry {
        protected char key;
        protected double value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, Double value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2DoubleMap.Entry) {
                Char2DoubleMap.Entry e2 = (Char2DoubleMap.Entry)o2;
                return this.key == e2.getCharKey() && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.key == ((Character)key).charValue() && Double.doubleToLongBits(this.value) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public int hashCode() {
            return this.key ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

