/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.chars.AbstractChar2BooleanFunction;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2BooleanMap;
import it.unimi.dsi.fastutil.chars.Char2BooleanMaps;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChar2BooleanMap
extends AbstractChar2BooleanFunction
implements Char2BooleanMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2BooleanMap() {
    }

    @Override
    public boolean containsValue(boolean v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(char k2) {
        Iterator i2 = this.char2BooleanEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Char2BooleanMap.Entry)i2.next()).getCharKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k2) {
                return AbstractChar2BooleanMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractChar2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2BooleanMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2BooleanMap.Entry> i;
                    {
                        this.i = Char2BooleanMaps.fastIterator(AbstractChar2BooleanMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2BooleanMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k2) {
                return AbstractChar2BooleanMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractChar2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Char2BooleanMap.Entry> i;
                    {
                        this.i = Char2BooleanMaps.fastIterator(AbstractChar2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Char2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Boolean> m2) {
        if (m2 instanceof Char2BooleanMap) {
            ObjectIterator<Char2BooleanMap.Entry> i2 = Char2BooleanMaps.fastIterator((Char2BooleanMap)m2);
            while (i2.hasNext()) {
                Char2BooleanMap.Entry e2 = (Char2BooleanMap.Entry)i2.next();
                this.put(e2.getCharKey(), e2.getBooleanValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Character, ? extends Boolean>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Character, ? extends Boolean> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Char2BooleanMap.Entry> i2 = Char2BooleanMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Char2BooleanMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.char2BooleanEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Char2BooleanMap.Entry> i2 = Char2BooleanMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Char2BooleanMap.Entry e2 = (Char2BooleanMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getCharKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getBooleanValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Char2BooleanMap.Entry> {
        protected final Char2BooleanMap map;

        public BasicEntrySet(Char2BooleanMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2BooleanMap.Entry) {
                Char2BooleanMap.Entry e2 = (Char2BooleanMap.Entry)o2;
                char k2 = e2.getCharKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k3 = ((Character)key).charValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Boolean)value).booleanValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2BooleanMap.Entry) {
                Char2BooleanMap.Entry e2 = (Char2BooleanMap.Entry)o2;
                return this.map.remove(e2.getCharKey(), e2.getBooleanValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k2 = ((Character)key).charValue();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            boolean v2 = (Boolean)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Char2BooleanMap.Entry {
        protected char key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, Boolean value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, boolean value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Char2BooleanMap.Entry) {
                Char2BooleanMap.Entry e2 = (Char2BooleanMap.Entry)o2;
                return this.key == e2.getCharKey() && this.value == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.key == ((Character)key).charValue() && this.value == (Boolean)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

