/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public interface ByteIterator
extends Iterator<Byte> {
    public byte nextByte();

    @Override
    @Deprecated
    default public Byte next() {
        return this.nextByte();
    }

    default public void forEachRemaining(ByteConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextByte());
        }
    }

    @Override
    @Deprecated
    default public void forEachRemaining(Consumer<? super Byte> action) {
        this.forEachRemaining(action::accept);
    }

    default public int skip(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Argument must be nonnegative: " + n2);
        }
        int i2 = n2;
        while (i2-- != 0 && this.hasNext()) {
            this.nextByte();
        }
        return n2 - i2 - 1;
    }
}

