/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractByte2ShortFunction;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2ShortMap;
import it.unimi.dsi.fastutil.bytes.Byte2ShortMaps;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractByte2ShortMap
extends AbstractByte2ShortFunction
implements Byte2ShortMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractByte2ShortMap() {
    }

    @Override
    public boolean containsValue(short v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(byte k2) {
        Iterator i2 = this.byte2ShortEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Byte2ShortMap.Entry)i2.next()).getByteKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet keySet() {
        return new AbstractByteSet(){

            @Override
            public boolean contains(byte k2) {
                return AbstractByte2ShortMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractByte2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2ShortMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Byte2ShortMap.Entry> i;
                    {
                        this.i = Byte2ShortMaps.fastIterator(AbstractByte2ShortMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Byte2ShortMap.Entry)this.i.next()).getByteKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            @Override
            public boolean contains(short k2) {
                return AbstractByte2ShortMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractByte2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2ShortMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Byte2ShortMap.Entry> i;
                    {
                        this.i = Byte2ShortMaps.fastIterator(AbstractByte2ShortMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Byte2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Short> m2) {
        if (m2 instanceof Byte2ShortMap) {
            ObjectIterator<Byte2ShortMap.Entry> i2 = Byte2ShortMaps.fastIterator((Byte2ShortMap)m2);
            while (i2.hasNext()) {
                Byte2ShortMap.Entry e2 = (Byte2ShortMap.Entry)i2.next();
                this.put(e2.getByteKey(), e2.getShortValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Byte, ? extends Short>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Byte, ? extends Short> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Byte2ShortMap.Entry> i2 = Byte2ShortMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Byte2ShortMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.byte2ShortEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Byte2ShortMap.Entry> i2 = Byte2ShortMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Byte2ShortMap.Entry e2 = (Byte2ShortMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getByteKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getShortValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Byte2ShortMap.Entry> {
        protected final Byte2ShortMap map;

        public BasicEntrySet(Byte2ShortMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2ShortMap.Entry) {
                Byte2ShortMap.Entry e2 = (Byte2ShortMap.Entry)o2;
                byte k2 = e2.getByteKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getShortValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k3 = (Byte)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Short)value).shortValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2ShortMap.Entry) {
                Byte2ShortMap.Entry e2 = (Byte2ShortMap.Entry)o2;
                return this.map.remove(e2.getByteKey(), e2.getShortValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k2 = (Byte)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            short v2 = (Short)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Byte2ShortMap.Entry {
        protected byte key;
        protected short value;

        public BasicEntry() {
        }

        public BasicEntry(Byte key, Short value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(byte key, short value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte getByteKey() {
            return this.key;
        }

        @Override
        public short getShortValue() {
            return this.value;
        }

        @Override
        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2ShortMap.Entry) {
                Byte2ShortMap.Entry e2 = (Byte2ShortMap.Entry)o2;
                return this.key == e2.getByteKey() && this.value == e2.getShortValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            return this.key == (Byte)key && this.value == (Short)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

