/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractByte2CharFunction;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2CharMap;
import it.unimi.dsi.fastutil.bytes.Byte2CharMaps;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractByte2CharMap
extends AbstractByte2CharFunction
implements Byte2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractByte2CharMap() {
    }

    @Override
    public boolean containsValue(char v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(byte k2) {
        Iterator i2 = this.byte2CharEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Byte2CharMap.Entry)i2.next()).getByteKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet keySet() {
        return new AbstractByteSet(){

            @Override
            public boolean contains(byte k2) {
                return AbstractByte2CharMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractByte2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2CharMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Byte2CharMap.Entry> i;
                    {
                        this.i = Byte2CharMaps.fastIterator(AbstractByte2CharMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Byte2CharMap.Entry)this.i.next()).getByteKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k2) {
                return AbstractByte2CharMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractByte2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Byte2CharMap.Entry> i;
                    {
                        this.i = Byte2CharMaps.fastIterator(AbstractByte2CharMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Byte2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Character> m2) {
        if (m2 instanceof Byte2CharMap) {
            ObjectIterator<Byte2CharMap.Entry> i2 = Byte2CharMaps.fastIterator((Byte2CharMap)m2);
            while (i2.hasNext()) {
                Byte2CharMap.Entry e2 = (Byte2CharMap.Entry)i2.next();
                this.put(e2.getByteKey(), e2.getCharValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Byte, ? extends Character>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Byte, ? extends Character> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Byte2CharMap.Entry> i2 = Byte2CharMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Byte2CharMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.byte2CharEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Byte2CharMap.Entry> i2 = Byte2CharMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Byte2CharMap.Entry e2 = (Byte2CharMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getByteKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getCharValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Byte2CharMap.Entry> {
        protected final Byte2CharMap map;

        public BasicEntrySet(Byte2CharMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2CharMap.Entry) {
                Byte2CharMap.Entry e2 = (Byte2CharMap.Entry)o2;
                byte k2 = e2.getByteKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getCharValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k3 = (Byte)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Character)value).charValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2CharMap.Entry) {
                Byte2CharMap.Entry e2 = (Byte2CharMap.Entry)o2;
                return this.map.remove(e2.getByteKey(), e2.getCharValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k2 = (Byte)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            char v2 = ((Character)value).charValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Byte2CharMap.Entry {
        protected byte key;
        protected char value;

        public BasicEntry() {
        }

        public BasicEntry(Byte key, Character value) {
            this.key = key;
            this.value = value.charValue();
        }

        public BasicEntry(byte key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte getByteKey() {
            return this.key;
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2CharMap.Entry) {
                Byte2CharMap.Entry e2 = (Byte2CharMap.Entry)o2;
                return this.key == e2.getByteKey() && this.value == e2.getCharValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.key == (Byte)key && this.value == ((Character)value).charValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

