/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByte2BooleanFunction;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanMap;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanMaps;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractByte2BooleanMap
extends AbstractByte2BooleanFunction
implements Byte2BooleanMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractByte2BooleanMap() {
    }

    @Override
    public boolean containsValue(boolean v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(byte k2) {
        Iterator i2 = this.byte2BooleanEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Byte2BooleanMap.Entry)i2.next()).getByteKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet keySet() {
        return new AbstractByteSet(){

            @Override
            public boolean contains(byte k2) {
                return AbstractByte2BooleanMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractByte2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2BooleanMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Byte2BooleanMap.Entry> i;
                    {
                        this.i = Byte2BooleanMaps.fastIterator(AbstractByte2BooleanMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Byte2BooleanMap.Entry)this.i.next()).getByteKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k2) {
                return AbstractByte2BooleanMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractByte2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Byte2BooleanMap.Entry> i;
                    {
                        this.i = Byte2BooleanMaps.fastIterator(AbstractByte2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Byte2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Boolean> m2) {
        if (m2 instanceof Byte2BooleanMap) {
            ObjectIterator<Byte2BooleanMap.Entry> i2 = Byte2BooleanMaps.fastIterator((Byte2BooleanMap)m2);
            while (i2.hasNext()) {
                Byte2BooleanMap.Entry e2 = (Byte2BooleanMap.Entry)i2.next();
                this.put(e2.getByteKey(), e2.getBooleanValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Byte, ? extends Boolean>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Byte, ? extends Boolean> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Byte2BooleanMap.Entry> i2 = Byte2BooleanMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Byte2BooleanMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.byte2BooleanEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Byte2BooleanMap.Entry> i2 = Byte2BooleanMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Byte2BooleanMap.Entry e2 = (Byte2BooleanMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getByteKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getBooleanValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Byte2BooleanMap.Entry> {
        protected final Byte2BooleanMap map;

        public BasicEntrySet(Byte2BooleanMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2BooleanMap.Entry) {
                Byte2BooleanMap.Entry e2 = (Byte2BooleanMap.Entry)o2;
                byte k2 = e2.getByteKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k3 = (Byte)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Boolean)value).booleanValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2BooleanMap.Entry) {
                Byte2BooleanMap.Entry e2 = (Byte2BooleanMap.Entry)o2;
                return this.map.remove(e2.getByteKey(), e2.getBooleanValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k2 = (Byte)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            boolean v2 = (Boolean)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Byte2BooleanMap.Entry {
        protected byte key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(Byte key, Boolean value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(byte key, boolean value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte getByteKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Byte2BooleanMap.Entry) {
                Byte2BooleanMap.Entry e2 = (Byte2BooleanMap.Entry)o2;
                return this.key == e2.getByteKey() && this.value == e2.getBooleanValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Boolean)) {
                return false;
            }
            return this.key == (Byte)key && this.value == (Boolean)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

