/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public interface BooleanIterator
extends Iterator<Boolean> {
    public boolean nextBoolean();

    @Override
    @Deprecated
    default public Boolean next() {
        return this.nextBoolean();
    }

    default public void forEachRemaining(BooleanConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextBoolean());
        }
    }

    @Override
    @Deprecated
    default public void forEachRemaining(Consumer<? super Boolean> action) {
        this.forEachRemaining(action::accept);
    }

    default public int skip(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Argument must be nonnegative: " + n2);
        }
        int i2 = n2;
        while (i2-- != 0 && this.hasNext()) {
            this.nextBoolean();
        }
        return n2 - i2 - 1;
    }
}

