/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Messages;
import com.mysql.cj.exceptions.NumberOutOfRange;
import com.mysql.cj.result.BaseDecoratingValueFactory;
import com.mysql.cj.result.ValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntegerBoundsEnforcer<T>
extends BaseDecoratingValueFactory<T> {
    private long min;
    private long max;

    public IntegerBoundsEnforcer(ValueFactory<T> targetVf, long min, long max) {
        super(targetVf);
        this.min = min;
        this.max = max;
    }

    @Override
    public T createFromLong(long l2) {
        if (l2 < this.min || l2 > this.max) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{Long.valueOf(l2).toString(), this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromLong(l2);
    }

    @Override
    public T createFromBigInteger(BigInteger i2) {
        if (i2.compareTo(BigInteger.valueOf(this.min)) < 0 || i2.compareTo(BigInteger.valueOf(this.max)) > 0) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{i2, this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromBigInteger(i2);
    }

    @Override
    public T createFromDouble(double d2) {
        if (d2 < (double)this.min || d2 > (double)this.max) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromDouble(d2);
    }

    @Override
    public T createFromBigDecimal(BigDecimal d2) {
        if (d2.compareTo(BigDecimal.valueOf(this.min)) < 0 || d2.compareTo(BigDecimal.valueOf(this.max)) > 0) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromBigDecimal(d2);
    }
}

