/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Messages;
import com.mysql.cj.exceptions.NumberOutOfRange;
import com.mysql.cj.result.BaseDecoratingValueFactory;
import com.mysql.cj.result.ValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FloatingPointBoundsEnforcer<T>
extends BaseDecoratingValueFactory<T> {
    private double min;
    private double max;

    public FloatingPointBoundsEnforcer(ValueFactory<T> targetVf, double min, double max) {
        super(targetVf);
        this.min = min;
        this.max = max;
    }

    @Override
    public T createFromLong(long l2) {
        if ((double)l2 < this.min || (double)l2 > this.max) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{l2, this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromLong(l2);
    }

    @Override
    public T createFromBigInteger(BigInteger i2) {
        if (new BigDecimal(i2).compareTo(BigDecimal.valueOf(this.min)) < 0 || new BigDecimal(i2).compareTo(BigDecimal.valueOf(this.max)) > 0) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{i2, this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromBigInteger(i2);
    }

    @Override
    public T createFromDouble(double d2) {
        if (d2 < this.min || d2 > this.max) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromDouble(d2);
    }

    @Override
    public T createFromBigDecimal(BigDecimal d2) {
        if (d2.compareTo(BigDecimal.valueOf(this.min)) < 0 || d2.compareTo(BigDecimal.valueOf(this.max)) > 0) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.targetVf.getTargetTypeName()}));
        }
        return this.targetVf.createFromBigDecimal(d2);
    }
}

