/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.result.DefaultValueFactory;
import com.mysql.cj.util.DataTypeUtil;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BooleanValueFactory
extends DefaultValueFactory<Boolean> {
    @Override
    public Boolean createFromLong(long l2) {
        return l2 == -1L || l2 > 0L;
    }

    @Override
    public Boolean createFromBigInteger(BigInteger i2) {
        return i2.compareTo(BigInteger.valueOf(0L)) > 0 || i2.compareTo(BigInteger.valueOf(-1L)) == 0;
    }

    @Override
    public Boolean createFromDouble(double d2) {
        return d2 > 0.0 || d2 == -1.0;
    }

    @Override
    public Boolean createFromBigDecimal(BigDecimal d2) {
        return d2.compareTo(BigDecimal.valueOf(0L)) > 0 || d2.compareTo(BigDecimal.valueOf(-1L)) == 0;
    }

    @Override
    public Boolean createFromBit(byte[] bytes, int offset, int length) {
        return this.createFromLong(DataTypeUtil.bitToLong(bytes, offset, length));
    }

    @Override
    public Boolean createFromNull() {
        return false;
    }

    @Override
    public String getTargetTypeName() {
        return Boolean.class.getName();
    }
}

