/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.protocol.x;

import com.mysql.cj.protocol.Warning;
import com.mysql.cj.protocol.x.Notice;
import com.mysql.cj.protocol.x.StatementExecuteOk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class StatementExecuteOkBuilder {
    private long rowsAffected = 0L;
    private Long lastInsertId = null;
    private List<String> generatedIds = Collections.emptyList();
    private List<Warning> warnings = new ArrayList<Warning>();

    public void addNotice(Notice notice) {
        if (notice instanceof Notice.XWarning) {
            this.warnings.add((Notice.XWarning)notice);
        } else if (notice instanceof Notice.XSessionStateChanged) {
            switch (((Notice.XSessionStateChanged)notice).getParamType()) {
                case 3: {
                    this.lastInsertId = ((Notice.XSessionStateChanged)notice).getValue().getVUnsignedInt();
                    break;
                }
                case 4: {
                    this.rowsAffected = ((Notice.XSessionStateChanged)notice).getValue().getVUnsignedInt();
                    break;
                }
                case 12: {
                    this.generatedIds = ((Notice.XSessionStateChanged)notice).getValueList().stream().map(v2 -> v2.getVOctets().getValue().toStringUtf8()).collect(Collectors.toList());
                    break;
                }
            }
        }
    }

    public StatementExecuteOk build() {
        return new StatementExecuteOk(this.rowsAffected, this.lastInsertId, this.generatedIds, this.warnings);
    }
}

