/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Serialization;
import java.nio.ByteBuffer;

public class KryoSerialization
implements Serialization {
    private final Kryo kryo;
    private final ByteBufferInput input;
    private final ByteBufferOutput output;

    public KryoSerialization() {
        this(new Kryo());
        this.kryo.setReferences(false);
        this.kryo.setRegistrationRequired(true);
    }

    public KryoSerialization(Kryo kryo) {
        this.kryo = kryo;
        kryo.register(FrameworkMessage.RegisterTCP.class);
        kryo.register(FrameworkMessage.RegisterUDP.class);
        kryo.register(FrameworkMessage.KeepAlive.class);
        kryo.register(FrameworkMessage.DiscoverHost.class);
        kryo.register(FrameworkMessage.Ping.class);
        this.input = new ByteBufferInput();
        this.output = new ByteBufferOutput();
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public synchronized void write(Connection connection, ByteBuffer buffer, Object object) {
        this.output.setBuffer(buffer);
        this.kryo.getContext().put("connection", connection);
        this.kryo.writeClassAndObject(this.output, object);
        this.output.flush();
    }

    public synchronized Object read(Connection connection, ByteBuffer buffer) {
        this.input.setBuffer(buffer);
        this.kryo.getContext().put("connection", connection);
        return this.kryo.readClassAndObject(this.input);
    }

    public void writeLength(ByteBuffer buffer, int length) {
        buffer.putInt(length);
    }

    public int readLength(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public int getLengthLength() {
        return 4;
    }
}

