/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Serialization;
import com.esotericsoftware.kryonet.TcpConnection;
import com.esotericsoftware.kryonet.UdpConnection;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;

public class Connection {
    int id = -1;
    private String name;
    EndPoint endPoint;
    TcpConnection tcp;
    UdpConnection udp;
    InetSocketAddress udpRemoteAddress;
    private Listener[] listeners = new Listener[0];
    private Object listenerLock = new Object();
    private int lastPingID;
    private long lastPingSendTime;
    private int returnTripTime;
    volatile boolean isConnected;

    protected Connection() {
    }

    void initialize(Serialization serialization, int writeBufferSize, int objectBufferSize) {
        this.tcp = new TcpConnection(serialization, writeBufferSize, objectBufferSize);
    }

    public int getID() {
        return this.id;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int sendTCP(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        try {
            int length = this.tcp.send(this, object);
            if (length == 0) {
                if (Log.TRACE) {
                    Log.trace("kryonet", this + " TCP had nothing to send.");
                }
            } else if (Log.DEBUG) {
                String objectString;
                String string = objectString = object == null ? "null" : object.getClass().getSimpleName();
                if (!(object instanceof FrameworkMessage)) {
                    Log.debug("kryonet", this + " sent TCP: " + objectString + " (" + length + ")");
                } else if (Log.TRACE) {
                    Log.trace("kryonet", this + " sent TCP: " + objectString + " (" + length + ")");
                }
            }
            return length;
        }
        catch (IOException ex) {
            if (Log.DEBUG) {
                Log.debug("kryonet", "Unable to send TCP with connection: " + this, ex);
            }
            this.close();
            return 0;
        }
        catch (KryoNetException ex) {
            if (Log.ERROR) {
                Log.error("kryonet", "Unable to send TCP with connection: " + this, ex);
            }
            this.close();
            return 0;
        }
    }

    public int sendUDP(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        InetSocketAddress address = this.udpRemoteAddress;
        if (address == null && this.udp != null) {
            address = this.udp.connectedAddress;
        }
        if (address == null && this.isConnected) {
            throw new IllegalStateException("Connection is not connected via UDP.");
        }
        try {
            if (address == null) {
                throw new SocketException("Connection is closed.");
            }
            int length = this.udp.send(this, object, address);
            if (length == 0) {
                if (Log.TRACE) {
                    Log.trace("kryonet", this + " UDP had nothing to send.");
                }
            } else if (Log.DEBUG) {
                if (length != -1) {
                    String objectString;
                    String string = objectString = object == null ? "null" : object.getClass().getSimpleName();
                    if (!(object instanceof FrameworkMessage)) {
                        Log.debug("kryonet", this + " sent UDP: " + objectString + " (" + length + ")");
                    } else if (Log.TRACE) {
                        Log.trace("kryonet", this + " sent UDP: " + objectString + " (" + length + ")");
                    }
                } else {
                    Log.debug("kryonet", this + " was unable to send, UDP socket buffer full.");
                }
            }
            return length;
        }
        catch (IOException ex) {
            if (Log.DEBUG) {
                Log.debug("kryonet", "Unable to send UDP with connection: " + this, ex);
            }
            this.close();
            return 0;
        }
        catch (KryoNetException ex) {
            if (Log.ERROR) {
                Log.error("kryonet", "Unable to send UDP with connection: " + this, ex);
            }
            this.close();
            return 0;
        }
    }

    public void close() {
        boolean wasConnected = this.isConnected;
        this.isConnected = false;
        this.tcp.close();
        if (this.udp != null && this.udp.connectedAddress != null) {
            this.udp.close();
        }
        if (wasConnected) {
            this.notifyDisconnected();
            if (Log.INFO) {
                Log.info("kryonet", this + " disconnected.");
            }
        }
        this.setConnected(false);
    }

    public void updateReturnTripTime() {
        FrameworkMessage.Ping ping = new FrameworkMessage.Ping();
        ping.id = this.lastPingID++;
        this.lastPingSendTime = System.currentTimeMillis();
        this.sendTCP(ping);
    }

    public int getReturnTripTime() {
        return this.returnTripTime;
    }

    public void setKeepAliveTCP(int keepAliveMillis) {
        this.tcp.keepAliveMillis = keepAliveMillis;
    }

    public void setTimeout(int timeoutMillis) {
        this.tcp.timeoutMillis = timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listeners = this.listeners;
            int n2 = listeners.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (listener != listeners[i2]) continue;
                return;
            }
            Listener[] newListeners = new Listener[n2 + 1];
            newListeners[0] = listener;
            System.arraycopy(listeners, 0, newListeners, 1, n2);
            this.listeners = newListeners;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Connection listener added: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listeners = this.listeners;
            int n2 = listeners.length;
            if (n2 == 0) {
                return;
            }
            Listener[] newListeners = new Listener[n2 - 1];
            int ii = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Listener copyListener = listeners[i2];
                if (listener == copyListener) continue;
                if (ii == n2 - 1) {
                    return;
                }
                newListeners[ii++] = copyListener;
            }
            this.listeners = newListeners;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Connection listener removed: " + listener.getClass().getName());
        }
    }

    void notifyConnected() {
        InetSocketAddress remoteSocketAddress;
        Socket socket;
        SocketChannel socketChannel;
        if (Log.INFO && (socketChannel = this.tcp.socketChannel) != null && (socket = this.tcp.socketChannel.socket()) != null && (remoteSocketAddress = (InetSocketAddress)socket.getRemoteSocketAddress()) != null) {
            Log.info("kryonet", this + " connected: " + remoteSocketAddress.getAddress());
        }
        Listener[] listeners = this.listeners;
        int n2 = listeners.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            listeners[i2].connected(this);
        }
    }

    void notifyDisconnected() {
        Listener[] listeners = this.listeners;
        int n2 = listeners.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            listeners[i2].disconnected(this);
        }
    }

    void notifyIdle() {
        Listener[] listeners = this.listeners;
        int n2 = listeners.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            listeners[i2].idle(this);
            if (!this.isIdle()) break;
        }
    }

    void notifyReceived(Object object) {
        if (object instanceof FrameworkMessage.Ping) {
            FrameworkMessage.Ping ping = (FrameworkMessage.Ping)object;
            if (ping.isReply) {
                if (ping.id == this.lastPingID - 1) {
                    this.returnTripTime = (int)(System.currentTimeMillis() - this.lastPingSendTime);
                    if (Log.TRACE) {
                        Log.trace("kryonet", this + " return trip time: " + this.returnTripTime);
                    }
                }
            } else {
                ping.isReply = true;
                this.sendTCP(ping);
            }
        }
        Listener[] listeners = this.listeners;
        int n2 = listeners.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            listeners[i2].received(this, object);
        }
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public InetSocketAddress getRemoteAddressTCP() {
        Socket socket;
        SocketChannel socketChannel = this.tcp.socketChannel;
        if (socketChannel != null && (socket = this.tcp.socketChannel.socket()) != null) {
            return (InetSocketAddress)socket.getRemoteSocketAddress();
        }
        return null;
    }

    public InetSocketAddress getRemoteAddressUDP() {
        InetSocketAddress connectedAddress = this.udp.connectedAddress;
        if (connectedAddress != null) {
            return connectedAddress;
        }
        return this.udpRemoteAddress;
    }

    public void setBufferPositionFix(boolean bufferPositionFix) {
        this.tcp.bufferPositionFix = bufferPositionFix;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTcpWriteBufferSize() {
        return this.tcp.writeBuffer.position();
    }

    public boolean isIdle() {
        return (float)this.tcp.writeBuffer.position() / (float)this.tcp.writeBuffer.capacity() < this.tcp.idleThreshold;
    }

    public void setIdleThreshold(float idleThreshold) {
        this.tcp.idleThreshold = idleThreshold;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return "Connection " + this.id;
    }

    void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
        if (isConnected && this.name == null) {
            this.name = "Connection " + this.id;
        }
    }
}

