/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import java.lang.reflect.Field;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientSoundProperties;

public class AmbientSelection {
    public double volume;
    public final AmbientCondition condition;
    public AmbientSelection subSelection = null;

    public AmbientSelection(AmbientCondition condition) {
        this.volume = condition.volume;
        this.condition = condition;
    }

    public double getEntireVolume() {
        return this.subSelection != null ? this.subSelection.getEntireVolume() * this.volume : this.volume;
    }

    public AmbientSelection getLast() {
        if (this.subSelection == null) {
            return this;
        }
        return this.subSelection.getLast();
    }

    public AmbientSoundProperties getProperties() {
        AmbientSoundProperties properties = new AmbientSoundProperties();
        this.assignProperties(properties);
        return properties;
    }

    protected void assignProperties(AmbientSoundProperties properties) {
        try {
            for (Field field : AmbientSoundProperties.class.getFields()) {
                Object value = field.get(this.condition);
                if (value == null) continue;
                field.set(properties, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (this.subSelection != null) {
            this.subSelection.assignProperties(properties);
        }
    }
}

