/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientEnviroment;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.ambientsounds.AmbientSoundProperties;
import team.creative.ambientsounds.utils.Pair;

public class AmbientCondition
extends AmbientSoundProperties {
    private static IForgeRegistry<Block> BLOCK_REGISTRY = GameRegistry.findRegistry(Block.class);
    public Boolean always;
    public double volume = 1.0;
    @SerializedName(value="night")
    public double nightVolume = 1.0;
    @SerializedName(value="day")
    public double dayVolume = 1.0;
    public String[] biomes;
    @SerializedName(value="bad-biomes")
    public String[] badBiomes;
    @SerializedName(value="special-biomes")
    public AmbientBiomeCondition specialBiome;
    public Boolean raining;
    public Boolean storming;
    public AmbientMinMaxFadeCondition underwater;
    @SerializedName(value="relative-height")
    public AmbientMinMaxFadeCondition relativeHeight;
    @SerializedName(value="absolute-height")
    public AmbientMinMaxFadeCondition absoluteHeight;
    @SerializedName(value="min-height-relative")
    public AmbientMinMaxFadeCondition minHeightRelative;
    @SerializedName(value="max-height-relative")
    public AmbientMinMaxFadeCondition maxHeightRelative;
    public AmbientMinMaxFadeCondition light;
    public AmbientMaterialCondition blocks;
    public AmbientCondition[] variants;
    public String[] regions;
    transient List<AmbientRegion> regionList;
    @SerializedName(value="bad-regions")
    public String[] badRegions;
    transient List<AmbientRegion> badRegionList;
    public Boolean outside;

    public String regionName() {
        return null;
    }

    @Override
    public void init(AmbientEngine engine) {
        AmbientRegion region;
        super.init(engine);
        this.volume = MathHelper.func_151237_a((double)this.volume, (double)0.0, (double)1.0);
        this.nightVolume = MathHelper.func_151237_a((double)this.nightVolume, (double)0.0, (double)1.0);
        this.dayVolume = MathHelper.func_151237_a((double)this.dayVolume, (double)0.0, (double)1.0);
        if (this.specialBiome != null) {
            this.specialBiome.init();
        }
        if (this.blocks != null) {
            this.blocks.init();
        }
        if (this.variants != null) {
            for (int i = 0; i < this.variants.length; ++i) {
                this.variants[i].init(engine);
            }
        }
        if (this.regions != null) {
            this.regionList = new ArrayList<AmbientRegion>();
            for (String regionName : this.regions) {
                region = engine.getRegion(regionName);
                if (region == null || regionName.equals(this.regionName())) continue;
                this.regionList.add(region);
            }
        }
        if (this.badRegions != null) {
            this.badRegionList = new ArrayList<AmbientRegion>();
            for (String regionName : this.badRegions) {
                region = engine.getRegion(regionName);
                if (region == null || regionName.equals(this.regionName())) continue;
                this.badRegionList.add(region);
            }
        }
    }

    public AmbientSelection value(AmbientEnviroment env) {
        Object highest;
        if (env.soundsDisabled) {
            return null;
        }
        if (this.always != null) {
            return this.always != false ? new AmbientSelection(this) : null;
        }
        if (this.volume <= 0.0) {
            return null;
        }
        if (env.night ? this.nightVolume <= 0.0 : this.dayVolume <= 0.0) {
            return null;
        }
        if (this.raining != null && env.raining != this.raining) {
            return null;
        }
        if (this.storming != null && env.thundering != this.storming) {
            return null;
        }
        if (this.outside != null && (this.outside != false ? env.blocks.outsideVolume == 0.0 : env.blocks.outsideVolume == 1.0)) {
            return null;
        }
        AmbientSelection selection = new AmbientSelection(this);
        selection.volume = selection.volume * (env.night ? this.nightVolume : this.dayVolume);
        if (this.outside != null) {
            selection.volume = this.outside.booleanValue() ? (selection.volume *= env.blocks.outsideVolume) : (selection.volume *= 1.0 - env.blocks.outsideVolume);
        }
        if (this.badRegionList != null) {
            for (AmbientRegion region : this.badRegionList) {
                if (!region.isActive()) continue;
                return null;
            }
        }
        if (this.regionList != null) {
            highest = null;
            for (AmbientRegion ambientRegion : this.regionList) {
                AmbientSelection subSelection = ambientRegion.value(env);
                if (subSelection == null) continue;
                if (highest == null) {
                    highest = subSelection.volume;
                    continue;
                }
                highest = Math.max(subSelection.volume, (Double)highest);
            }
            if (highest == null) {
                return null;
            }
            selection.volume *= ((Double)highest).doubleValue();
        }
        if (this.biomes != null || this.badBiomes != null || this.specialBiome != null) {
            highest = null;
            for (Pair pair : env.biomes) {
                if (this.biomes != null && !((AmbientEnviroment.BiomeArea)pair.key).checkBiome(this.biomes)) continue;
                if (this.badBiomes != null && ((AmbientEnviroment.BiomeArea)pair.key).checkBiome(this.badBiomes)) {
                    return null;
                }
                if (this.specialBiome != null && !this.specialBiome.is((AmbientEnviroment.BiomeArea)pair.key) || highest != null && !(((Float)((Pair)highest).value).floatValue() < ((Float)pair.value).floatValue())) continue;
                highest = pair;
            }
            if (highest == null && (this.biomes != null || this.specialBiome != null)) {
                return null;
            }
            if (highest != null) {
                selection.volume *= (double)((Float)((Pair)highest).value).floatValue();
            }
        }
        if (this.underwater != null) {
            double volume = this.underwater.volume(env.underwater);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.relativeHeight != null) {
            double volume = this.relativeHeight.volume(env.relativeHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.minHeightRelative != null) {
            double volume = this.minHeightRelative.volume(env.player.func_226280_cw_() - (double)env.minHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.maxHeightRelative != null) {
            double volume = this.maxHeightRelative.volume(env.player.func_226280_cw_() - (double)env.maxHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.absoluteHeight != null) {
            double volume = this.absoluteHeight.volume(env.player.func_226280_cw_());
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.light != null) {
            double volume = this.light.volume(env.blocks.averageLight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.blocks != null) {
            double volume = this.blocks.volume(env);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.variants != null) {
            AmbientSelection bestCondition = null;
            for (Iterator<AmbientRegion> iterator : this.variants) {
                AmbientSelection subSelection = ((AmbientCondition)((Object)iterator)).value(env);
                if (subSelection == null || bestCondition != null && !(bestCondition.volume < subSelection.volume)) continue;
                bestCondition = subSelection;
            }
            if (bestCondition == null) {
                return null;
            }
            selection.subSelection = bestCondition;
        }
        return selection;
    }

    public static class AmbientMaterialCondition {
        public String[] materials;
        @SerializedName(value="bad-materials")
        public String[] badMaterials;
        transient List<Material> mat;
        transient List<Material> badMat;
        static Material[] refMaterials = new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151575_d, Material.field_151576_e, Material.field_151573_f, Material.field_151574_g, Material.field_151586_h, Material.field_151587_i, Material.field_151584_j, Material.field_151585_k, Material.field_151582_l, Material.field_151583_m, Material.field_151580_n, Material.field_151581_o, Material.field_151595_p, Material.field_151594_q, Material.field_151593_r, Material.field_151592_s, Material.field_151591_t, Material.field_151590_u, Material.field_151589_v, Material.field_151588_w, Material.field_151598_x, Material.field_151597_y, Material.field_151570_A, Material.field_151571_B, Material.field_151572_C, Material.field_151566_D, Material.field_151567_E, Material.field_151568_F, Material.field_151569_G, Material.field_76233_E, Material.field_175972_I, Material.field_189963_J};
        static String[] refMaterialNames = new String[]{"GRASS", "GROUND", "WOOD", "ROCK", "IRON", "ANVIL", "WATER", "LAVA", "LEAVES", "PLANTS", "TALL_PLANTS", "SPONGE", "WOOL", "FIRE", "SAND", "MISCELLANEOUS", "CARPET", "GLASS", "REDSTONE_LIGHT", "TNT", "CORAL", "ICE", "PACKED_ICE", "SNOW", "CACTUS", "CLAY", "GOURD", "DRAGON_EGG", "PORTAL", "CAKE", "WEB", "PISTON", "BARRIER", "STRUCTURE_VOID"};

        public void init() {
            Material material;
            if (this.materials != null) {
                this.mat = new ArrayList<Material>();
                for (String string : this.materials) {
                    material = AmbientMaterialCondition.getMaterial(string);
                    if (material == null) continue;
                    this.mat.add(material);
                }
            }
            if (this.badMaterials != null) {
                this.badMat = new ArrayList<Material>();
                for (String string : this.badMaterials) {
                    material = AmbientMaterialCondition.getMaterial(string);
                    if (material == null) continue;
                    this.badMat.add(material);
                }
            }
        }

        public double volume(AmbientEnviroment env) {
            if (this.materials == null && this.badMaterials == null) {
                return 1.0;
            }
            boolean found = false;
            for (AmbientEnviroment.BlockSpot spot : env.blocks.spots) {
                if (spot == null) continue;
                if (!found && this.materials != null && this.mat.contains(spot.getMaterial())) {
                    found = true;
                }
                if (this.badMaterials == null || !this.badMat.contains(spot.getMaterial())) continue;
                return 0.0;
            }
            return found ? 1.0 : 0.0;
        }

        public static Material getMaterial(String name) {
            for (int i = 0; i < refMaterialNames.length; ++i) {
                if (!refMaterialNames[i].equalsIgnoreCase(name)) continue;
                return refMaterials[i];
            }
            return null;
        }
    }

    public static class AmbientMinMaxFadeCondition
    extends AmbientMinMaxCondition {
        public Double fade;

        public double volume(double value) {
            if (!this.is(value)) {
                return 0.0;
            }
            if (this.fade == null) {
                return 1.0;
            }
            double volume = 1.0;
            if (this.min != null) {
                volume = MathHelper.func_151237_a((double)(Math.abs(value - this.min) / this.fade), (double)0.0, (double)1.0);
            }
            if (this.max != null) {
                volume = Math.min(volume, MathHelper.func_151237_a((double)(Math.abs(value - this.max) / this.fade), (double)0.0, (double)1.0));
            }
            return volume;
        }
    }

    public static class AmbientMinMaxCondition {
        public Double min;
        public Double max;

        public boolean is(double value) {
            if (this.min != null && value < this.min) {
                return false;
            }
            return this.max == null || !(value > this.max);
        }

        public double randomValue() {
            if (this.max == null) {
                if (this.min == null) {
                    return 0.0;
                }
                return this.min;
            }
            if (this.min == null) {
                this.min = 0.0;
            }
            double distance = this.max - this.min;
            return Math.random() * distance + this.min;
        }
    }

    public static class AmbientBiomeCondition {
        @SerializedName(value="top-block")
        public String[] topBlock;
        transient List<Block> blocks;
        public AmbientMinMaxCondition temperature;
        @SerializedName(value="trees-per-chunk")
        public AmbientMinMaxCondition treesPerChunk;
        @SerializedName(value="waterlily-per-chunk")
        public AmbientMinMaxCondition waterlilyPerChunk;
        @SerializedName(value="flowers-per-chunk")
        public AmbientMinMaxCondition flowersPerChunk;
        @SerializedName(value="grass-per-chunk")
        public AmbientMinMaxCondition grassPerChunk;
        @SerializedName(value="deadbush-per-chunk")
        public AmbientMinMaxCondition deadBushPerChunk;
        @SerializedName(value="mushrooms-per-chunk")
        public AmbientMinMaxCondition mushroomsPerChunk;
        @SerializedName(value="reeds-per-chunk")
        public AmbientMinMaxCondition reedsPerChunk;
        @SerializedName(value="cacti-per-chunk")
        public AmbientMinMaxCondition cactiPerChunk;

        public void init() {
            if (this.topBlock != null) {
                this.blocks = new ArrayList<Block>();
                for (String blockName : this.topBlock) {
                    Block block = (Block)BLOCK_REGISTRY.getValue(new ResourceLocation(blockName));
                    if (block == null || block instanceof AirBlock) continue;
                    this.blocks.add(block);
                }
            }
        }

        public boolean is(AmbientEnviroment.BiomeArea biome) {
            if (this.topBlock != null && !biome.checkTopBlock(this.blocks)) {
                return false;
            }
            if (this.temperature != null && !this.temperature.is(biome.biome.func_225486_c(biome.pos))) {
                return false;
            }
            return this.treesPerChunk == null;
        }
    }
}

