/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class IngredientFluidStack
extends Ingredient {
    private final FluidStack fluid;
    private ItemStack[] cachedStacks;

    public IngredientFluidStack(FluidStack fluid) {
        super(0);
        this.fluid = fluid;
    }

    public IngredientFluidStack(Fluid fluid, int amount) {
        this(new FluidStack(fluid, amount));
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            this.cachedStacks = new ItemStack[]{FluidUtil.getFilledBucket((FluidStack)this.fluid)};
        }
        return this.cachedStacks;
    }

    public boolean apply(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        return fs == null && this.fluid == null || fs != null && fs.containsFluid(this.fluid);
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            String name = JsonUtils.func_151200_h((JsonObject)json, (String)"fluid");
            int amount = JsonUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
            Fluid fluid = FluidRegistry.getFluid((String)name);
            if (fluid == null) {
                throw new JsonSyntaxException("Fluid with name " + name + " could not be found");
            }
            return new IngredientFluidStack(fluid, amount);
        }
    }
}

