/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.packer;

import com.codetaylor.mc.athenaeum.packer.ImageCollector;
import com.codetaylor.mc.athenaeum.packer.ImageMetaData;
import com.codetaylor.mc.athenaeum.packer.PackData;
import com.codetaylor.mc.athenaeum.packer.PackDataPathResolver;
import com.codetaylor.mc.athenaeum.packer.PackedData;
import com.codetaylor.mc.athenaeum.packer.atlas.Atlas;
import com.codetaylor.mc.athenaeum.packer.atlas.Lease;
import com.codetaylor.mc.athenaeum.packer.atlas.LeaseComparator;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;

public class Packer {
    private final Gson gson;
    private final Supplier<PackData> packDataSupplier;
    private final PackDataPathResolver packDataPathResolver;
    private final ImageCollector imageCollector;

    public Packer(Gson gson, Supplier<PackData> packDataSupplier, PackDataPathResolver packDataPathResolver, ImageCollector imageCollector) {
        this.gson = gson;
        this.packDataSupplier = packDataSupplier;
        this.packDataPathResolver = packDataPathResolver;
        this.imageCollector = imageCollector;
    }

    public void run() throws IOException {
        System.out.println("Loading pack.json data...");
        PackData packData = this.packDataSupplier.get();
        this.packDataPathResolver.resolve(packData.paths.input);
        System.out.println("Collecting images...");
        Map<String, Map<String, ImageCollector.ImageData>> atlasImageMap = this.imageCollector.collect(packData.paths.input);
        System.out.println("Creating logical atlases...");
        HashMap<String, Atlas> atlasMap = new HashMap<String, Atlas>();
        for (String string : atlasImageMap.keySet()) {
            PackData.AtlasData atlasData = packData.atlas_definitions.get(string);
            if (atlasData == null) {
                throw new RuntimeException("Missing atlas definition for: " + string);
            }
            Atlas atlas = new Atlas(atlasData.width, atlasData.height, Integer.MAX_VALUE);
            atlasMap.put(string, atlas);
            System.out.println("  -> " + string);
        }
        System.out.println("Creating atlas leases and packing images...");
        HashMap<String, Map<String, Integer>> atlasLeaseMap = new HashMap<String, Map<String, Integer>>();
        for (Map.Entry<String, Map<String, ImageCollector.ImageData>> entry : atlasImageMap.entrySet()) {
            int n = 0;
            String atlasId = entry.getKey();
            Atlas atlas = (Atlas)atlasMap.get(atlasId);
            Map<String, ImageCollector.ImageData> images = entry.getValue();
            HashMap<String, Integer> leases = new HashMap<String, Integer>();
            for (Map.Entry<String, ImageCollector.ImageData> imageEntry : images.entrySet()) {
                ImageCollector.ImageData imageData = imageEntry.getValue();
                BufferedImage image = imageData.image;
                int width = image.getWidth();
                int height = image.getHeight();
                atlas.insert(n, width, height);
                String imageId = imageEntry.getKey();
                leases.put(imageId, n);
                System.out.println("  -> " + atlasId + ":" + imageId + ", id:" + n);
                ++n;
            }
            atlas.repack(LeaseComparator.LARGE_FIRST);
            atlasLeaseMap.put(atlasId, leases);
        }
        System.out.println("Creating atlas images...");
        HashMap<String, List<BufferedImage>> hashMap = new HashMap<String, List<BufferedImage>>();
        this.createAtlasImages(packData, atlasImageMap, atlasMap, atlasLeaseMap, hashMap);
        System.out.println("Writing atlas images...");
        for (Map.Entry entry : hashMap.entrySet()) {
            String atlasId = (String)entry.getKey();
            PackData.AtlasData atlasData = packData.atlas_definitions.get(atlasId);
            Path path = atlasData.path != null ? Paths.get(packData.paths.outputString, atlasData.path) : Paths.get(packData.paths.outputString, new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            List imageList = (List)entry.getValue();
            for (int i = 0; i < imageList.size(); ++i) {
                Path atlasFilePath = this.resolveAtlasImagePath(atlasId, i, packData.paths.outputString, atlasData.path);
                ImageIO.write((RenderedImage)imageList.get(i), "PNG", atlasFilePath.toFile());
                System.out.format("  -> %s\n", atlasFilePath.toString().replaceAll("\\\\", "/"));
            }
        }
        System.out.println("Collecting packed data...");
        PackedData packedData = this.collectPackedData(packData, atlasImageMap, atlasMap, atlasLeaseMap);
        System.out.println("Writing packed.json data...");
        Path path = Paths.get(packData.paths.outputString, "packed.json");
        File file = path.toFile();
        FileWriter writer = new FileWriter(file);
        this.gson.toJson((Object)packedData, (Appendable)writer);
        writer.close();
        System.out.format("  -> %s\n", path.toString().replaceAll("\\\\", "/"));
    }

    private void createAtlasImages(PackData packData, Map<String, Map<String, ImageCollector.ImageData>> atlasImageMap, Map<String, Atlas> atlasMap, Map<String, Map<String, Integer>> atlasLeaseMap, Map<String, List<BufferedImage>> atlasImageListMap) {
        for (Map.Entry<String, Atlas> entry : atlasMap.entrySet()) {
            String atlasId = entry.getKey();
            Atlas atlas = entry.getValue();
            Map<String, ImageCollector.ImageData> imageMap = atlasImageMap.get(atlasId);
            Map<String, Integer> leaseMap = atlasLeaseMap.get(atlasId);
            ArrayList<BufferedImage> atlasImageList = new ArrayList<BufferedImage>();
            atlasImageListMap.put(atlasId, atlasImageList);
            PackData.AtlasData atlasData = packData.atlas_definitions.get(atlasId);
            for (Map.Entry<String, ImageCollector.ImageData> imageEntry : imageMap.entrySet()) {
                BufferedImage bufferedImage;
                String imageId = imageEntry.getKey();
                ImageCollector.ImageData collectorImageData = imageEntry.getValue();
                BufferedImage image = collectorImageData.image;
                int leaseId = leaseMap.get(imageId);
                Lease lease = atlas.leaseGet(leaseId);
                int page = lease.getPage();
                while (atlasImageList.size() <= page) {
                    bufferedImage = new BufferedImage(atlasData.width, atlasData.height, 2);
                    atlasImageList.add(bufferedImage);
                }
                bufferedImage = (BufferedImage)atlasImageList.get(page);
                int[] rgb = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
                bufferedImage.setRGB(lease.getPosX(), lease.getPosY(), image.getWidth(), image.getHeight(), rgb, 0, image.getWidth());
                System.out.println("  -> " + atlasId + ":" + imageId + ", page:" + page + " @ (" + lease.getPosX() + ", " + lease.getPosY() + ")");
            }
        }
    }

    private PackedData collectPackedData(PackData packData, Map<String, Map<String, ImageCollector.ImageData>> atlasImageMap, Map<String, Atlas> atlasMap, Map<String, Map<String, Integer>> atlasLeaseMap) {
        PackedData packedData = new PackedData();
        for (Map.Entry<String, Atlas> entry : atlasMap.entrySet()) {
            String atlasId = entry.getKey();
            Atlas atlas = entry.getValue();
            Map<String, ImageCollector.ImageData> imageMap = atlasImageMap.get(atlasId);
            Map<String, Integer> leaseMap = atlasLeaseMap.get(atlasId);
            PackData.AtlasData atlasData = packData.atlas_definitions.get(atlasId);
            int totalPages = 0;
            for (Map.Entry<String, ImageCollector.ImageData> imageEntry : imageMap.entrySet()) {
                ImageMetaData metaData;
                String imageId = imageEntry.getKey();
                ImageCollector.ImageData collectorImageData = imageEntry.getValue();
                int leaseId = leaseMap.get(imageId);
                Lease lease = atlas.leaseGet(leaseId);
                int page = lease.getPage();
                if (page + 1 > totalPages) {
                    totalPages = page + 1;
                }
                if ((metaData = collectorImageData.metaData) != null && metaData.subImages != null && metaData.subImages.size() > 0) {
                    for (Map.Entry<String, ImageMetaData.ImageData> metaEntry : metaData.subImages.entrySet()) {
                        String subImageString = metaEntry.getKey();
                        ImageMetaData.ImageData imageData = metaEntry.getValue();
                        PackedData.ImageData packedImageData = new PackedData.ImageData();
                        packedImageData.atlas = this.resolveAtlasImagePathString(atlasId, page, packData.paths.resourcePath, atlasData.path);
                        packedImageData.u = lease.getPosX() + imageData.x;
                        packedImageData.v = lease.getPosY() + imageData.y;
                        packedImageData.width = imageData.width;
                        packedImageData.height = imageData.height;
                        String actualImageId = this.getActualImageId(imageId, metaData) + "#" + subImageString;
                        packedData.image.put(actualImageId, packedImageData);
                    }
                    continue;
                }
                PackedData.ImageData packedImageData = new PackedData.ImageData();
                packedImageData.atlas = this.resolveAtlasImagePathString(atlasId, page, packData.paths.resourcePath, atlasData.path);
                packedImageData.u = lease.getPosX();
                packedImageData.v = lease.getPosY();
                packedImageData.width = lease.getWidth();
                packedImageData.height = lease.getHeight();
                String actualImageId = this.getActualImageId(imageId, metaData);
                packedData.image.put(actualImageId, packedImageData);
            }
            PackedData.AtlasData packedAtlasData = new PackedData.AtlasData();
            packedAtlasData.width = atlasData.width;
            packedAtlasData.height = atlasData.height;
            for (int i = 0; i < totalPages; ++i) {
                String imagePathString = this.resolveAtlasImagePathString(atlasId, i, packData.paths.resourcePath, atlasData.path);
                packedData.atlas.put(imagePathString, packedAtlasData);
            }
        }
        return packedData;
    }

    private String getActualImageId(String imageId, ImageMetaData metaData) {
        String actualImageId = metaData != null && metaData.id != null ? metaData.id : imageId;
        return actualImageId;
    }

    private String resolveAtlasImagePathString(String atlasId, int page, String outputString, String atlasPath) {
        return this.resolveAtlasImagePath(atlasId, page, outputString, atlasPath).toString().replaceAll("\\\\", "/");
    }

    private Path resolveAtlasImagePath(String atlasId, int page, String outputString, String atlasPath) {
        Path path = atlasPath != null ? Paths.get(outputString, atlasPath) : Paths.get(outputString, new String[0]);
        return path.resolve(atlasId + "_" + page + ".png");
    }
}

