/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.packer;

import com.codetaylor.mc.athenaeum.packer.ImageCollector;
import com.codetaylor.mc.athenaeum.packer.ImageMetaData;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageVisitor
extends SimpleFileVisitor<Path> {
    private final Gson gson;
    private final Path path;
    private final Map<String, ImageCollector.ImageData> imageMap;

    public ImageVisitor(Gson gson, Path path, Map<String, ImageCollector.ImageData> imageMap) {
        this.gson = gson;
        this.path = path;
        this.imageMap = imageMap;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
        String fileString = file.toString();
        String id = fileString;
        if (id.startsWith(this.path.toString())) {
            id = id.substring(this.path.toString().length() + 1);
        }
        if (attr.isRegularFile()) {
            if (id.endsWith(".png")) {
                System.out.format("  -> %s", id);
                BufferedImage image = ImageIO.read(file.toFile());
                System.out.format(" [%d x %d]", image.getWidth(), image.getHeight());
                id = id.replaceAll("\\\\", "/").substring(0, id.length() - 4);
                ImageCollector.ImageData imageData = this.imageMap.computeIfAbsent(id, s -> new ImageCollector.ImageData());
                imageData.image = image;
            } else if (id.endsWith(".json")) {
                System.out.format("  -> %s", id);
                id = id.replaceAll("\\\\", "/").substring(0, id.length() - 9);
                String jsonFileString = fileString.substring(0, fileString.length() - 5);
                Path imagePath = Paths.get(jsonFileString, new String[0]);
                if (Files.exists(imagePath, new LinkOption[0])) {
                    ImageMetaData imageMetaData = (ImageMetaData)this.gson.fromJson((Reader)new FileReader(Paths.get(jsonFileString + ".json", new String[0]).toFile()), ImageMetaData.class);
                    ImageCollector.ImageData imageData = this.imageMap.computeIfAbsent(id, s -> new ImageCollector.ImageData());
                    imageData.metaData = imageMetaData;
                }
            }
        }
        System.out.println(" (" + attr.size() + " b)");
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        System.out.format("  -> %s%n", dir);
        return FileVisitResult.CONTINUE;
    }
}

