/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.network;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CSPacketInteractionMouseWheel
implements IMessage,
IMessageHandler<CSPacketInteractionMouseWheel, IMessage> {
    private BlockPos origin;
    private int wheelDelta;
    private EnumFacing facing;
    private Vec3d hitVec;

    public CSPacketInteractionMouseWheel() {
    }

    public CSPacketInteractionMouseWheel(BlockPos origin, int wheelDelta, EnumFacing facing, Vec3d hitVec) {
        this.origin = origin;
        this.wheelDelta = wheelDelta;
        this.facing = facing;
        this.hitVec = hitVec;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.origin = pb.func_179259_c();
        this.wheelDelta = pb.readInt();
        this.facing = EnumFacing.field_82609_l[pb.readByte()];
        this.hitVec = new Vec3d(pb.readDouble(), pb.readDouble(), pb.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_179255_a(this.origin);
        pb.writeInt(this.wheelDelta);
        pb.writeByte(this.facing.func_176745_a());
        pb.writeDouble(this.hitVec.field_72450_a);
        pb.writeDouble(this.hitVec.field_72448_b);
        pb.writeDouble(this.hitVec.field_72449_c);
    }

    public IMessage onMessage(CSPacketInteractionMouseWheel message, MessageContext ctx) {
        if (message.wheelDelta != 0) {
            NetHandlerPlayServer serverHandler = ctx.getServerHandler();
            EntityPlayerMP player = serverHandler.field_147369_b;
            World world = player.func_130014_f_();
            BlockPos origin = message.origin;
            EnumFacing facing = message.facing;
            IBlockState blockState = world.func_180495_p(origin);
            Block block = blockState.func_177230_c();
            if (block instanceof IBlockInteractable) {
                IInteraction.EnumType type = message.wheelDelta > 0 ? IInteraction.EnumType.MouseWheelUp : IInteraction.EnumType.MouseWheelDown;
                ((IBlockInteractable)block).interact(type, world, origin, blockState, (EntityPlayer)player, EnumHand.MAIN_HAND, facing, (float)message.hitVec.field_72450_a, (float)message.hitVec.field_72448_b, (float)message.hitVec.field_72449_c);
            }
        }
        return null;
    }
}

