/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wit.sync;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import p455w0rd.wit.sync.WITPacket;
import p455w0rd.wit.sync.packets.PacketCompressedNBT;
import p455w0rd.wit.sync.packets.PacketInventoryAction;
import p455w0rd.wit.sync.packets.PacketOpenGui;

public class WITPacketHandlerBase {
    private static final Map<Class<? extends WITPacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends WITPacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_COMPRESSED_NBT(PacketCompressedNBT.class),
        PACKET_INVENTORY_ACTION(PacketInventoryAction.class),
        PACKET_OPENWIRELESSTERM(PacketOpenGui.class);

        private final Class<? extends WITPacket> packetClass;
        private final Constructor<? extends WITPacket> packetConstructor;

        private PacketTypes(Class<? extends WITPacket> c) {
            this.packetClass = c;
            Constructor<? extends WITPacket> x = null;
            try {
                x = this.packetClass.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
            this.packetConstructor = x;
            REVERSE_LOOKUP.put(this.packetClass, this);
            if (this.packetConstructor == null) {
                throw new IllegalStateException("Invalid Packet Class " + c + ", must be constructable on DataInputStream");
            }
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends WITPacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public WITPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.packetConstructor.newInstance(in);
        }
    }
}

