/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.common.blocks.BlockLeavesRustic;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.blocks.ModBlocks;
import rustic.compat.dynamictrees.BiomeDataBasePopulator;
import rustic.compat.dynamictrees.SaplingReplacer;
import rustic.compat.dynamictrees.trees.TreeIronwood;
import rustic.compat.dynamictrees.trees.TreeOlive;

public class DynamicTreesCompat {
    public static ILeavesProperties oliveLeavesProperties;
    public static ILeavesProperties ironwoodLeavesProperties;
    public static TreeFamily oliveTree;
    public static TreeFamily ironwoodTree;

    @Optional.Method(modid="dynamictrees")
    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    public static void preInit() {
        IForgeRegistry blockRegistry = GameRegistry.findRegistry(Block.class);
        IForgeRegistry itemRegistry = GameRegistry.findRegistry(Item.class);
        oliveLeavesProperties = new LeavesProperties(ModBlocks.LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeavesRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.OLIVE)), new ItemStack(Item.func_150898_a((Block)ModBlocks.LEAVES), 1, BlockPlanksRustic.EnumType.OLIVE.getMetadata()));
        ironwoodLeavesProperties = new LeavesProperties(ModBlocks.LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeavesRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.IRONWOOD)), new ItemStack(Item.func_150898_a((Block)ModBlocks.LEAVES), 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()));
        LeavesPaging.getLeavesBlockForSequence((String)"rustic", (int)0, (ILeavesProperties)oliveLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"rustic", (int)1, (ILeavesProperties)ironwoodLeavesProperties);
        oliveTree = new TreeOlive();
        ironwoodTree = new TreeIronwood();
        oliveTree.registerSpecies(Species.REGISTRY);
        ironwoodTree.registerSpecies(Species.REGISTRY);
        ArrayList treeBlocks = new ArrayList();
        oliveTree.getRegisterableBlocks(treeBlocks);
        ironwoodTree.getRegisterableBlocks(treeBlocks);
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"rustic").values());
        blockRegistry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
        ArrayList treeItems = new ArrayList();
        oliveTree.getRegisterableItems(treeItems);
        ironwoodTree.getRegisterableItems(treeItems);
        itemRegistry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
        if (ModConfigs.replaceVanillaSapling) {
            MinecraftForge.EVENT_BUS.register((Object)new SaplingReplacer());
        }
    }

    public static void init() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPreInit() {
        ModelHelper.regModel((Block)oliveTree.getDynamicBranch());
        ModelHelper.regModel((Block)ironwoodTree.getDynamicBranch());
        ModelHelper.regModel((Item)oliveTree.getCommonSpecies().getSeed());
        ModelHelper.regModel((Item)ironwoodTree.getCommonSpecies().getSeed());
        ModelHelper.regModel((TreeFamily)oliveTree);
        ModelHelper.regModel((TreeFamily)ironwoodTree);
        LeavesPaging.getLeavesMapForModId((String)"rustic").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientInit() {
        int magenta = 0xFF00FF;
        for (BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId((String)"rustic").values()) {
            ModelHelper.regColorHandler((Block)leaves, (IBlockColor)new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    Block block = state.func_177230_c();
                    if (TreeHelper.isLeaves((Block)block)) {
                        return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
        }
    }

    public static Item getOliveSeed() {
        return oliveTree.getCommonSpecies().getSeed();
    }

    public static Item getIronwoodSeed() {
        return ironwoodTree.getCommonSpecies().getSeed();
    }

    public static Item getAppleSeed() {
        return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "apple")).getSeed();
    }

    public static void addRecipes() {
        ItemStack oliveSeeds = oliveTree.getCommonSpecies().getSeedStack(1);
        ItemStack ironwoodSeeds = ironwoodTree.getCommonSpecies().getSeedStack(1);
        ItemStack transformationPotion = new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex());
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack((Block)ModBlocks.SAPLING, 1, BlockPlanksRustic.EnumType.OLIVE.getMetadata()), (ItemStack)oliveSeeds, (boolean)true);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack((Block)ModBlocks.SAPLING, 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()), (ItemStack)ironwoodSeeds, (boolean)true);
        BrewingRecipeRegistry.addRecipe((ItemStack)transformationPotion, (ItemStack)oliveSeeds, (ItemStack)ModItems.dendroPotion.setTargetTree(transformationPotion.func_77946_l(), oliveTree));
        BrewingRecipeRegistry.addRecipe((ItemStack)transformationPotion, (ItemStack)ironwoodSeeds, (ItemStack)ModItems.dendroPotion.setTargetTree(transformationPotion.func_77946_l(), ironwoodTree));
    }

    public static boolean replaceWorldGen() {
        return WorldGenRegistry.isWorldGenEnabled();
    }
}

